/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationBuilder;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.HttpBasedServiceCredential;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.support.SimpleTestUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.cas.authentication.principal.SimpleWebApplicationServiceImpl;
import org.jasig.cas.validation.Assertion;
import org.jasig.cas.validation.ImmutableAssertion;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.validation.BindException;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.test.MockRequestContext;

public final class TestUtils {
    public static final String CONST_USERNAME = "test";
    private static final String CONST_PASSWORD = "test1";
    private static final String CONST_BAD_URL = "http://www.acs.rutgers.edu";
    private static final String CONST_CREDENTIALS = "credentials";
    private static final String CONST_WEBFLOW_BIND_EXCEPTION = "org.springframework.validation.BindException.credentials";
    private static final String[] CONST_NO_PRINCIPALS = new String[0];
    public static final String CONST_EXCEPTION_EXPECTED = "Exception expected.";
    public static final String CONST_EXCEPTION_NON_EXPECTED = "Exception not expected.";
    public static final String CONST_GOOD_URL = "https://github.com/";

    private TestUtils() {
    }

    public static UsernamePasswordCredential getCredentialsWithSameUsernameAndPassword() {
        return TestUtils.getCredentialsWithSameUsernameAndPassword(CONST_USERNAME);
    }

    public static UsernamePasswordCredential getCredentialsWithSameUsernameAndPassword(String username) {
        return TestUtils.getCredentialsWithDifferentUsernameAndPassword(username, username);
    }

    public static UsernamePasswordCredential getCredentialsWithDifferentUsernameAndPassword() {
        return TestUtils.getCredentialsWithDifferentUsernameAndPassword(CONST_USERNAME, CONST_PASSWORD);
    }

    public static UsernamePasswordCredential getCredentialsWithDifferentUsernameAndPassword(String username, String password) {
        UsernamePasswordCredential usernamePasswordCredentials = new UsernamePasswordCredential();
        usernamePasswordCredentials.setUsername(username);
        usernamePasswordCredentials.setPassword(password);
        return usernamePasswordCredentials;
    }

    public static HttpBasedServiceCredential getHttpBasedServiceCredentials() {
        return TestUtils.getHttpBasedServiceCredentials(CONST_GOOD_URL);
    }

    public static HttpBasedServiceCredential getBadHttpBasedServiceCredentials() {
        return TestUtils.getHttpBasedServiceCredentials(CONST_BAD_URL);
    }

    public static HttpBasedServiceCredential getHttpBasedServiceCredentials(String url) {
        try {
            return new HttpBasedServiceCredential(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException();
        }
    }

    public static Principal getPrincipal() {
        return TestUtils.getPrincipal(CONST_USERNAME);
    }

    public static Principal getPrincipal(String name) {
        return new SimplePrincipal(name);
    }

    public static Service getService() {
        return TestUtils.getService(CONST_USERNAME);
    }

    public static Service getService(String name) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("service", name);
        return SimpleWebApplicationServiceImpl.createServiceFrom((HttpServletRequest)request);
    }

    public static Authentication getAuthentication() {
        return TestUtils.getAuthentication(CONST_USERNAME);
    }

    public static Authentication getAuthentication(String name) {
        return TestUtils.getAuthentication(TestUtils.getPrincipal(name));
    }

    public static Authentication getAuthentication(Principal principal) {
        return TestUtils.getAuthentication(principal, Collections.<String, Object>emptyMap());
    }

    public static Authentication getAuthentication(Principal principal, Map<String, Object> attributes) {
        SimpleTestUsernamePasswordAuthenticationHandler handler = new SimpleTestUsernamePasswordAuthenticationHandler();
        BasicCredentialMetaData meta = new BasicCredentialMetaData((Credential)new UsernamePasswordCredential());
        return new AuthenticationBuilder(principal).addCredential((CredentialMetaData)meta).addSuccess("testHandler", new HandlerResult((AuthenticationHandler)handler, (CredentialMetaData)meta)).setAttributes(attributes).build();
    }

    public static Authentication getAuthenticationWithService() {
        return TestUtils.getAuthentication((Principal)TestUtils.getService());
    }

    public static Assertion getAssertion(boolean fromNewLogin) {
        return TestUtils.getAssertion(fromNewLogin, CONST_NO_PRINCIPALS);
    }

    public static Assertion getAssertion(boolean fromNewLogin, String[] extraPrincipals) {
        ArrayList<Authentication> list = new ArrayList<Authentication>();
        list.add(TestUtils.getAuthentication());
        for (int i = 0; i < extraPrincipals.length; ++i) {
            list.add(TestUtils.getAuthentication(extraPrincipals[i]));
        }
        return new ImmutableAssertion(TestUtils.getAuthentication(), list, TestUtils.getService(), fromNewLogin);
    }

    public static MockRequestContext getContext() {
        return TestUtils.getContext(new MockHttpServletRequest());
    }

    public static MockRequestContext getContext(MockHttpServletRequest request) {
        return TestUtils.getContext(request, new MockHttpServletResponse());
    }

    public static MockRequestContext getContext(MockHttpServletRequest request, MockHttpServletResponse response) {
        MockRequestContext context = new MockRequestContext();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        return context;
    }

    public static MockRequestContext getContextWithCredentials(MockHttpServletRequest request) {
        return TestUtils.getContextWithCredentials(request, new MockHttpServletResponse());
    }

    public static MockRequestContext getContextWithCredentials(MockHttpServletRequest request, MockHttpServletResponse response) {
        MockRequestContext context = TestUtils.getContext(request, response);
        context.getRequestScope().put(CONST_CREDENTIALS, (Object)TestUtils.getCredentialsWithSameUsernameAndPassword());
        context.getRequestScope().put(CONST_WEBFLOW_BIND_EXCEPTION, (Object)new BindException((Object)TestUtils.getCredentialsWithSameUsernameAndPassword(), CONST_CREDENTIALS));
        return context;
    }
}

