/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import javax.security.auth.login.LoginException;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.handler.support.JaasAuthenticationHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasAuthenticationHandlerTests {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private JaasAuthenticationHandler handler;

    @Before
    public void setUp() throws Exception {
        String pathPrefix = System.getProperty("user.dir");
        pathPrefix = !pathPrefix.contains("cas-server-core") ? pathPrefix + "/cas-server-core" : pathPrefix;
        this.logger.info("PATH PREFIX: {}", (Object)pathPrefix);
        String pathToConfig = pathPrefix + "/src/test/resources/org/jasig/cas/authentication/handler/support/jaas.conf";
        System.setProperty("java.security.auth.login.config", "=" + pathToConfig);
        this.handler = new JaasAuthenticationHandler();
    }

    @Test(expected=LoginException.class)
    public void testWithAlternativeRealm() throws Exception {
        this.handler.setRealm("TEST");
        this.handler.authenticate((Credential)TestUtils.getCredentialsWithDifferentUsernameAndPassword("test", "test1"));
    }

    @Test
    public void testWithAlternativeRealmAndValidCredentials() throws Exception {
        this.handler.setRealm("TEST");
        Assert.assertNotNull((Object)this.handler.authenticate((Credential)TestUtils.getCredentialsWithDifferentUsernameAndPassword("test", "test")));
    }

    @Test
    public void testWithValidCredenials() throws Exception {
        Assert.assertNotNull((Object)this.handler.authenticate((Credential)TestUtils.getCredentialsWithSameUsernameAndPassword()));
    }

    @Test(expected=LoginException.class)
    public void testWithInvalidCredentials() throws Exception {
        this.handler.authenticate((Credential)TestUtils.getCredentialsWithDifferentUsernameAndPassword("test", "test1"));
    }
}

