/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.logout;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SimpleWebApplicationServiceImpl;
import org.jasig.cas.logout.LogoutManagerImpl;
import org.jasig.cas.logout.LogoutMessageCreator;
import org.jasig.cas.logout.LogoutRequest;
import org.jasig.cas.logout.LogoutRequestStatus;
import org.jasig.cas.logout.SamlCompliantLogoutMessageCreator;
import org.jasig.cas.services.LogoutType;
import org.jasig.cas.services.RegisteredServiceImpl;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.util.HttpClient;
import org.jasig.cas.util.SimpleHttpClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class LogoutManagerImplTests {
    private static final String ID = "id";
    private static final String URL = "http://url";
    private LogoutManagerImpl logoutManager;
    private TicketGrantingTicket tgt;
    private Map<String, Service> services;
    private SimpleWebApplicationServiceImpl simpleWebApplicationServiceImpl;
    private RegisteredServiceImpl registeredService;

    @Before
    public void setUp() {
        ServicesManager servicesManager = (ServicesManager)Mockito.mock(ServicesManager.class);
        this.logoutManager = new LogoutManagerImpl(servicesManager, (HttpClient)new SimpleHttpClient(), (LogoutMessageCreator)new SamlCompliantLogoutMessageCreator());
        this.tgt = (TicketGrantingTicket)Mockito.mock(TicketGrantingTicket.class);
        this.services = new HashMap<String, Service>();
        this.simpleWebApplicationServiceImpl = new SimpleWebApplicationServiceImpl(URL);
        this.services.put(ID, (Service)this.simpleWebApplicationServiceImpl);
        Mockito.when((Object)this.tgt.getServices()).thenReturn(this.services);
        this.registeredService = new RegisteredServiceImpl();
        Mockito.when((Object)servicesManager.findServiceBy((Service)this.simpleWebApplicationServiceImpl)).thenReturn((Object)this.registeredService);
    }

    @Test
    public void testLogoutDisabled() {
        this.logoutManager.setDisableSingleSignOut(true);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)0L, (long)logoutRequests.size());
    }

    @Test
    public void testLogoutAlreadyLoggedOut() {
        this.simpleWebApplicationServiceImpl.setLoggedOutAlready(true);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)0L, (long)logoutRequests.size());
    }

    @Test
    public void testLogoutTypeNull() {
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)1L, (long)logoutRequests.size());
        LogoutRequest logoutRequest = (LogoutRequest)logoutRequests.iterator().next();
        Assert.assertEquals((Object)ID, (Object)logoutRequest.getTicketId());
        Assert.assertEquals((Object)this.simpleWebApplicationServiceImpl, (Object)logoutRequest.getService());
        Assert.assertEquals((Object)LogoutRequestStatus.SUCCESS, (Object)logoutRequest.getStatus());
    }

    @Test
    public void testLogoutTypeBack() {
        this.registeredService.setLogoutType(LogoutType.BACK_CHANNEL);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)1L, (long)logoutRequests.size());
        LogoutRequest logoutRequest = (LogoutRequest)logoutRequests.iterator().next();
        Assert.assertEquals((Object)ID, (Object)logoutRequest.getTicketId());
        Assert.assertEquals((Object)this.simpleWebApplicationServiceImpl, (Object)logoutRequest.getService());
        Assert.assertEquals((Object)LogoutRequestStatus.SUCCESS, (Object)logoutRequest.getStatus());
    }

    @Test
    public void testLogoutTypeFront() {
        this.registeredService.setLogoutType(LogoutType.FRONT_CHANNEL);
        List logoutRequests = this.logoutManager.performLogout(this.tgt);
        Assert.assertEquals((long)1L, (long)logoutRequests.size());
        LogoutRequest logoutRequest = (LogoutRequest)logoutRequests.iterator().next();
        Assert.assertEquals((Object)ID, (Object)logoutRequest.getTicketId());
        Assert.assertEquals((Object)this.simpleWebApplicationServiceImpl, (Object)logoutRequest.getService());
        Assert.assertEquals((Object)LogoutRequestStatus.NOT_ATTEMPTED, (Object)logoutRequest.getStatus());
    }
}

