/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import java.util.Collections;
import java.util.HashSet;
import org.jasig.cas.monitor.HealthCheckMonitor;
import org.jasig.cas.monitor.MemoryMonitor;
import org.jasig.cas.monitor.Monitor;
import org.jasig.cas.monitor.SessionMonitor;
import org.jasig.cas.monitor.Status;
import org.jasig.cas.monitor.StatusCode;
import org.jasig.cas.monitor.TicketRegistryState;
import org.jasig.cas.ticket.registry.DefaultTicketRegistry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HealthCheckMonitorTests {
    private HealthCheckMonitor monitor;

    @Before
    public void setUp() throws Exception {
        this.monitor = new HealthCheckMonitor();
    }

    @Test
    public void testObserveUnknown() throws Exception {
        Assert.assertEquals((Object)StatusCode.UNKNOWN, (Object)this.monitor.observe().getCode());
    }

    @Test
    public void testObserveOk() throws Exception {
        HashSet<Object> monitors = new HashSet<Object>();
        monitors.add(new MemoryMonitor());
        monitors.add(this.newSessionMonitor());
        this.monitor.setMonitors(monitors);
        Assert.assertEquals((Object)StatusCode.OK, (Object)this.monitor.observe().getCode());
    }

    @Test
    public void testObserveWarn() throws Exception {
        HashSet<Object> monitors = new HashSet<Object>();
        MemoryMonitor memoryMonitor = new MemoryMonitor();
        memoryMonitor.setFreeMemoryWarnThreshold(100L);
        monitors.add(memoryMonitor);
        monitors.add(this.newSessionMonitor());
        this.monitor.setMonitors(monitors);
        Assert.assertEquals((Object)StatusCode.WARN, (Object)this.monitor.observe().getCode());
    }

    @Test
    public void testThrowsUncheckedException() throws Exception {
        Monitor throwsUnchecked = new Monitor(){

            public String getName() {
                return "ThrowsUnchecked";
            }

            public Status observe() {
                throw new IllegalStateException("Boogity!");
            }
        };
        this.monitor.setMonitors(Collections.singleton(throwsUnchecked));
        Assert.assertEquals((Object)StatusCode.ERROR, (Object)this.monitor.observe().getCode());
    }

    private SessionMonitor newSessionMonitor() {
        SessionMonitor sessionMonitor = new SessionMonitor();
        sessionMonitor.setTicketRegistry((TicketRegistryState)new DefaultTicketRegistry());
        return sessionMonitor;
    }
}

