/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.remoting.server;

import org.jasig.cas.AbstractCentralAuthenticationServiceTest;
import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.remoting.server.RemoteCentralAuthenticationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RemoteCentralAuthenticationServiceTests
extends AbstractCentralAuthenticationServiceTest {
    private RemoteCentralAuthenticationService remoteCentralAuthenticationService;

    @Before
    public void onSetUp() throws Exception {
        this.remoteCentralAuthenticationService = new RemoteCentralAuthenticationService();
        this.remoteCentralAuthenticationService.setCentralAuthenticationService(this.getCentralAuthenticationService());
    }

    @Test
    public void testValidCredentials() throws Exception {
        this.remoteCentralAuthenticationService.createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
    }

    @Test
    public void testInvalidCredentials() throws Exception {
        try {
            this.remoteCentralAuthenticationService.createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithDifferentUsernameAndPassword(null, null)});
            Assert.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException e) {
            return;
        }
    }

    @Test
    public void testDontUseValidatorsToCheckValidCredentials() throws Exception {
        try {
            this.remoteCentralAuthenticationService.createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithDifferentUsernameAndPassword()});
            Assert.fail((String)"AuthenticationException expected.");
        }
        catch (AuthenticationException e) {
            return;
        }
    }

    @Test
    public void testDestroyTicketGrantingTicket() {
        this.remoteCentralAuthenticationService.destroyTicketGrantingTicket("test");
    }

    @Test
    public void testGrantServiceTicketWithValidTicketGrantingTicket() throws Exception {
        String ticketId = this.remoteCentralAuthenticationService.createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        this.remoteCentralAuthenticationService.grantServiceTicket(ticketId, TestUtils.getService());
    }

    @Test
    public void testGrantServiceTicketWithValidCredentials() throws Exception {
        String ticketGrantingTicketId = this.remoteCentralAuthenticationService.createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        this.remoteCentralAuthenticationService.grantServiceTicket(ticketGrantingTicketId, TestUtils.getService(), new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
    }

    @Test
    public void testGrantServiceTicketWithNullCredentials() throws Exception {
        String ticketGrantingTicketId = this.remoteCentralAuthenticationService.createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        this.remoteCentralAuthenticationService.grantServiceTicket(ticketGrantingTicketId, TestUtils.getService(), null);
    }

    @Test
    public void testGrantServiceTicketWithEmptyCredentials() throws Exception {
        String ticketGrantingTicketId = this.remoteCentralAuthenticationService.createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        try {
            this.remoteCentralAuthenticationService.grantServiceTicket(ticketGrantingTicketId, TestUtils.getService(), new Credential[]{TestUtils.getCredentialsWithDifferentUsernameAndPassword("", "")});
            Assert.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException e) {
            return;
        }
    }

    @Test
    public void testValidateServiceTicketWithValidService() throws Exception {
        String ticketGrantingTicket = this.remoteCentralAuthenticationService.createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        String serviceTicket = this.remoteCentralAuthenticationService.grantServiceTicket(ticketGrantingTicket, TestUtils.getService());
        this.remoteCentralAuthenticationService.validateServiceTicket(serviceTicket, TestUtils.getService());
    }

    @Test
    public void testDelegateTicketGrantingTicketWithValidCredentials() throws Exception {
        String ticketGrantingTicket = this.remoteCentralAuthenticationService.createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        String serviceTicket = this.remoteCentralAuthenticationService.grantServiceTicket(ticketGrantingTicket, TestUtils.getService());
        this.remoteCentralAuthenticationService.delegateTicketGrantingTicket(serviceTicket, new Credential[]{TestUtils.getHttpBasedServiceCredentials()});
    }

    @Test
    public void testDelegateTicketGrantingTicketWithInvalidCredentials() throws Exception {
        String ticketGrantingTicket = this.remoteCentralAuthenticationService.createTicketGrantingTicket(new Credential[]{TestUtils.getCredentialsWithSameUsernameAndPassword()});
        String serviceTicket = this.remoteCentralAuthenticationService.grantServiceTicket(ticketGrantingTicket, TestUtils.getService());
        try {
            this.remoteCentralAuthenticationService.delegateTicketGrantingTicket(serviceTicket, new Credential[]{TestUtils.getCredentialsWithDifferentUsernameAndPassword("", "")});
            Assert.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException e) {
            return;
        }
    }
}

