/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.Arrays;
import java.util.List;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.services.AbstractRegisteredService;
import org.jasig.cas.services.RegexRegisteredService;
import org.jasig.cas.services.RegisteredServiceImpl;
import org.junit.Assert;
import org.junit.Test;

public class AbstractRegisteredServiceTests {
    private AbstractRegisteredService r = new AbstractRegisteredService(){
        private static final long serialVersionUID = 1L;

        public void setServiceId(String id) {
            this.serviceId = id;
        }

        protected AbstractRegisteredService newInstance() {
            return this;
        }

        public boolean matches(Service service) {
            return true;
        }
    };

    @Test
    public void testAllowToProxyIsFalseByDefault() {
        RegexRegisteredService regexRegisteredService = new RegexRegisteredService();
        Assert.assertFalse((boolean)regexRegisteredService.isAllowedToProxy());
        RegisteredServiceImpl registeredServiceImpl = new RegisteredServiceImpl();
        Assert.assertFalse((boolean)registeredServiceImpl.isAllowedToProxy());
    }

    @Test
    public void testSettersAndGetters() {
        long ID = 1000L;
        String DESCRIPTION = "test";
        String SERVICEID = "serviceId";
        String THEME = "theme";
        String NAME = "name";
        boolean ENABLED = false;
        boolean ALLOWED_TO_PROXY = false;
        boolean ANONYMOUS_ACCESS = true;
        boolean SSO_ENABLED = false;
        List<String> ALLOWED_ATTRIBUTES = Arrays.asList("Test");
        this.r.setAllowedAttributes(ALLOWED_ATTRIBUTES);
        this.r.setAllowedToProxy(false);
        this.r.setAnonymousAccess(true);
        this.r.setDescription("test");
        this.r.setEnabled(false);
        this.r.setId(1000L);
        this.r.setName("name");
        this.r.setServiceId("serviceId");
        this.r.setSsoEnabled(false);
        this.r.setTheme("theme");
        Assert.assertEquals(ALLOWED_ATTRIBUTES, (Object)this.r.getAllowedAttributes());
        Assert.assertEquals((Object)false, (Object)this.r.isAllowedToProxy());
        Assert.assertEquals((Object)true, (Object)this.r.isAnonymousAccess());
        Assert.assertEquals((Object)"test", (Object)this.r.getDescription());
        Assert.assertEquals((Object)false, (Object)this.r.isEnabled());
        Assert.assertEquals((long)1000L, (long)this.r.getId());
        Assert.assertEquals((Object)"name", (Object)this.r.getName());
        Assert.assertEquals((Object)"serviceId", (Object)this.r.getServiceId());
        Assert.assertEquals((Object)false, (Object)this.r.isSsoEnabled());
        Assert.assertEquals((Object)"theme", (Object)this.r.getTheme());
        Assert.assertFalse((boolean)this.r.equals(null));
        Assert.assertFalse((boolean)this.r.equals(new Object()));
        Assert.assertTrue((boolean)this.r.equals((Object)this.r));
        this.r.setAllowedAttributes(null);
        Assert.assertNotNull((Object)this.r.getAllowedAttributes());
    }

    @Test
    public void testEquals() throws Exception {
        Assert.assertTrue((boolean)this.r.equals((Object)this.r.clone()));
        Assert.assertFalse((boolean)new RegisteredServiceImpl().equals(null));
        Assert.assertFalse((boolean)new RegisteredServiceImpl().equals(new Object()));
    }
}

