/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.ArrayList;
import java.util.Map;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.services.DefaultServicesManagerImpl;
import org.jasig.cas.services.InMemoryServiceRegistryDaoImpl;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceImpl;
import org.jasig.cas.services.ServiceRegistryDao;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultServicesManagerImplTests {
    private DefaultServicesManagerImpl defaultServicesManagerImpl;

    @Before
    public void setUp() throws Exception {
        InMemoryServiceRegistryDaoImpl dao = new InMemoryServiceRegistryDaoImpl();
        ArrayList<RegisteredServiceImpl> list = new ArrayList<RegisteredServiceImpl>();
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setId(2500L);
        r.setServiceId("serviceId");
        r.setName("serviceName");
        r.setEvaluationOrder(1000);
        list.add(r);
        dao.setRegisteredServices(list);
        this.defaultServicesManagerImpl = new DefaultServicesManagerImpl((ServiceRegistryDao)dao);
    }

    @Test
    public void testSaveAndGet() {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setId(1000L);
        r.setName("test");
        r.setServiceId("test");
        this.defaultServicesManagerImpl.save((RegisteredService)r);
        Assert.assertNotNull((Object)this.defaultServicesManagerImpl.findServiceBy(1000L));
    }

    @Test
    public void testMultiServicesBySameName() {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setId(666L);
        r.setName("testServiceName");
        r.setServiceId("testServiceA");
        this.defaultServicesManagerImpl.save((RegisteredService)r);
        r = new RegisteredServiceImpl();
        r.setId(999L);
        r.setName("testServiceName");
        r.setServiceId("testServiceB");
        this.defaultServicesManagerImpl.save((RegisteredService)r);
        Assert.assertEquals((long)3L, (long)this.defaultServicesManagerImpl.getAllServices().size());
    }

    @Test
    public void testSaveWithReturnedPersistedInstance() {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setId(1000L);
        r.setName("test");
        r.setServiceId("test");
        RegisteredService persistedRs = this.defaultServicesManagerImpl.save((RegisteredService)r);
        Assert.assertNotNull((Object)persistedRs);
        Assert.assertEquals((long)1000L, (long)persistedRs.getId());
    }

    @Test
    public void testDeleteAndGet() {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setId(1000L);
        r.setName("test");
        r.setServiceId("test");
        this.defaultServicesManagerImpl.save((RegisteredService)r);
        Assert.assertEquals((Object)r, (Object)this.defaultServicesManagerImpl.findServiceBy(r.getId()));
        this.defaultServicesManagerImpl.delete(r.getId());
        Assert.assertNull((Object)this.defaultServicesManagerImpl.findServiceBy(r.getId()));
    }

    @Test
    public void testDeleteNotExistentService() {
        Assert.assertNull((Object)this.defaultServicesManagerImpl.delete(1500L));
    }

    @Test
    public void testMatchesExistingService() {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setId(1000L);
        r.setName("test");
        r.setServiceId("test");
        SimpleService service = new SimpleService("test");
        SimpleService service2 = new SimpleService("fdfa");
        this.defaultServicesManagerImpl.save((RegisteredService)r);
        Assert.assertTrue((boolean)this.defaultServicesManagerImpl.matchesExistingService((Service)service));
        Assert.assertEquals((Object)r, (Object)this.defaultServicesManagerImpl.findServiceBy((Service)service));
        Assert.assertNull((Object)this.defaultServicesManagerImpl.findServiceBy((Service)service2));
    }

    @Test
    public void testAllService() {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setId(1000L);
        r.setName("test");
        r.setServiceId("test");
        r.setEvaluationOrder(2);
        this.defaultServicesManagerImpl.save((RegisteredService)r);
        Assert.assertEquals((long)2L, (long)this.defaultServicesManagerImpl.getAllServices().size());
        Assert.assertTrue((boolean)this.defaultServicesManagerImpl.getAllServices().contains(r));
    }

    @Test
    public void testEmptyServicesRegistry() {
        SimpleService s = new SimpleService("http://www.google.com");
        for (RegisteredService svc : this.defaultServicesManagerImpl.getAllServices()) {
            this.defaultServicesManagerImpl.delete(svc.getId());
        }
        Assert.assertTrue((this.defaultServicesManagerImpl.getAllServices().size() == 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)this.defaultServicesManagerImpl.findServiceBy((Service)s));
        Assert.assertNull((Object)this.defaultServicesManagerImpl.findServiceBy(1000L));
    }

    @Test
    public void testEvaluationOrderOfServices() {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setId(100L);
        r.setName("test");
        r.setServiceId("test");
        r.setEvaluationOrder(200);
        RegisteredServiceImpl r2 = new RegisteredServiceImpl();
        r2.setId(101L);
        r2.setName("test");
        r2.setServiceId("test");
        r2.setEvaluationOrder(80);
        RegisteredServiceImpl r3 = new RegisteredServiceImpl();
        r3.setId(102L);
        r3.setName("Sample test service");
        r3.setServiceId("test");
        r3.setEvaluationOrder(80);
        this.defaultServicesManagerImpl.save((RegisteredService)r);
        this.defaultServicesManagerImpl.save((RegisteredService)r3);
        this.defaultServicesManagerImpl.save((RegisteredService)r2);
        ArrayList allServices = new ArrayList(this.defaultServicesManagerImpl.getAllServices());
        Assert.assertEquals((long)4L, (long)allServices.size());
        Assert.assertEquals((long)((RegisteredService)allServices.get(0)).getId(), (long)r3.getId());
        Assert.assertEquals((long)((RegisteredService)allServices.get(1)).getId(), (long)r2.getId());
        Assert.assertEquals((long)((RegisteredService)allServices.get(2)).getId(), (long)r.getId());
    }

    protected class SimpleService
    implements Service {
        private static final long serialVersionUID = 6572142033945243669L;
        private String id;

        protected SimpleService(String id) {
            this.id = id;
        }

        public Map<String, Object> getAttributes() {
            return null;
        }

        public String getId() {
            return this.id;
        }

        public void setPrincipal(Principal principal) {
        }

        public boolean matches(Service service) {
            return true;
        }
    }
}

