/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.Arrays;
import java.util.Collection;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.mock.MockService;
import org.jasig.cas.services.RegexRegisteredService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RegexRegisteredServiceTests {
    private RegexRegisteredService service;
    private String serviceToMatch;
    private boolean expected;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        String domainCatchallHttp = "https*://([A-Za-z0-9_-]+\\.)+vt\\.edu/.*";
        String domainCatchallHttpImap = "(https*|imaps*)://([A-Za-z0-9_-]+\\.)+vt\\.edu/.*";
        String globalCatchallHttpImap = "(https*|imaps*)://.*";
        return Arrays.asList({RegexRegisteredServiceTests.newService("https*://([A-Za-z0-9_-]+\\.)+vt\\.edu/.*"), "https://service.vt.edu/webapp?a=1", true}, {RegexRegisteredServiceTests.newService("https*://([A-Za-z0-9_-]+\\.)+vt\\.edu/.*"), "http://test-01.service.vt.edu/webapp?a=1", true}, {RegexRegisteredServiceTests.newService("https*://([A-Za-z0-9_-]+\\.)+vt\\.edu/.*"), "https://thepiratebay.se?service.vt.edu/webapp?a=1", false}, {RegexRegisteredServiceTests.newService("(https*|imaps*)://([A-Za-z0-9_-]+\\.)+vt\\.edu/.*"), "http://test_service.vt.edu/login", true}, {RegexRegisteredServiceTests.newService("(https*|imaps*)://([A-Za-z0-9_-]+\\.)+vt\\.edu/.*"), "imaps://imap-server-01.vt.edu/", true}, {RegexRegisteredServiceTests.newService("(https*|imaps*)://.*"), "https://host-01.example.com/", true}, {RegexRegisteredServiceTests.newService("(https*|imaps*)://.*"), "imap://host-02.example.edu/", true}, {RegexRegisteredServiceTests.newService("(https*|imaps*)://.*"), null, false});
    }

    public RegexRegisteredServiceTests(RegexRegisteredService service, String serviceToMatch, boolean expectedResult) {
        this.service = service;
        this.serviceToMatch = serviceToMatch;
        this.expected = expectedResult;
    }

    @Test
    public void testMatches() throws Exception {
        MockService testService = this.serviceToMatch == null ? null : new MockService(this.serviceToMatch);
        Assert.assertEquals((Object)this.expected, (Object)this.service.matches((Service)testService));
    }

    private static RegexRegisteredService newService(String id) {
        RegexRegisteredService service = new RegexRegisteredService();
        service.setServiceId(id);
        return service;
    }
}

