/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.support;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceAttributeFilter;
import org.jasig.cas.services.support.RegisteredServiceDefaultAttributeFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class RegisteredServiceDefaultAttributeFilterTests {
    private RegisteredServiceAttributeFilter filter = new RegisteredServiceDefaultAttributeFilter();
    private Map<String, Object> givenAttributesMap = new HashMap<String, Object>();
    @Mock
    private RegisteredService registeredService;

    public RegisteredServiceDefaultAttributeFilterTests() {
        this.givenAttributesMap.put("uid", "loggedInTestUid");
        this.givenAttributesMap.put("phone", "1234567890");
        this.givenAttributesMap.put("familyName", "Smith");
        this.givenAttributesMap.put("givenName", "John");
        this.givenAttributesMap.put("employeeId", "E1234");
        this.givenAttributesMap.put("memberOf", Arrays.asList("math", "science", "chemistry"));
    }

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.registeredService.getName()).thenReturn((Object)"sample test service");
        Mockito.when((Object)this.registeredService.getServiceId()).thenReturn((Object)"https://www.jasig.org");
        Mockito.when((Object)this.registeredService.getAllowedAttributes()).thenReturn(Arrays.asList("uid", "givenName", "memberOf", "isNotAllowed"));
    }

    @Test
    public void testDefaultFilter() {
        Mockito.when((Object)this.registeredService.isIgnoreAttributes()).thenReturn((Object)false);
        Map map = this.filter.filter("uid", this.givenAttributesMap, this.registeredService);
        Assert.assertEquals((long)map.size(), (long)3L);
        Mockito.when((Object)this.registeredService.isIgnoreAttributes()).thenReturn((Object)true);
        map = this.filter.filter("uid", this.givenAttributesMap, this.registeredService);
        Assert.assertEquals((long)map.size(), (long)this.givenAttributesMap.size());
        Assert.assertEquals((Object)map, this.givenAttributesMap);
        List memberOfAttr = (List)map.get("memberOf");
        Assert.assertEquals((long)memberOfAttr.size(), (long)((List)this.givenAttributesMap.get("memberOf")).size());
    }
}

