/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket;

import org.jasig.cas.TestUtils;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.ServiceTicketImpl;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.support.MultiTimeUseOrTimeoutExpirationPolicy;
import org.jasig.cas.ticket.support.NeverExpiresExpirationPolicy;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.junit.Assert;
import org.junit.Test;

public class ServiceTicketImplTests {
    private TicketGrantingTicketImpl ticketGrantingTicket = new TicketGrantingTicketImpl("test", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
    private UniqueTicketIdGenerator uniqueTicketIdGenerator = new DefaultUniqueTicketIdGenerator();

    @Test(expected=Exception.class)
    public void testNoService() {
        new ServiceTicketImpl("stest1", this.ticketGrantingTicket, null, true, (ExpirationPolicy)new NeverExpiresExpirationPolicy());
    }

    @Test(expected=Exception.class)
    public void testNoTicket() {
        new ServiceTicketImpl("stest1", null, TestUtils.getService(), true, (ExpirationPolicy)new NeverExpiresExpirationPolicy());
    }

    @Test
    public void testIsFromNewLoginTrue() {
        ServiceTicketImpl s = new ServiceTicketImpl("stest1", this.ticketGrantingTicket, TestUtils.getService(), true, (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        Assert.assertTrue((boolean)s.isFromNewLogin());
    }

    @Test
    public void testIsFromNewLoginFalse() {
        ServiceTicketImpl s = new ServiceTicketImpl("stest1", this.ticketGrantingTicket, TestUtils.getService(), false, (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        Assert.assertFalse((boolean)s.isFromNewLogin());
    }

    @Test
    public void testGetService() {
        Service simpleService = TestUtils.getService();
        ServiceTicketImpl s = new ServiceTicketImpl("stest1", this.ticketGrantingTicket, simpleService, false, (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        Assert.assertEquals((Object)simpleService, (Object)s.getService());
    }

    @Test
    public void testGetTicket() {
        Service simpleService = TestUtils.getService();
        ServiceTicketImpl s = new ServiceTicketImpl("stest1", this.ticketGrantingTicket, simpleService, false, (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        Assert.assertEquals((Object)this.ticketGrantingTicket, (Object)s.getGrantingTicket());
    }

    @Test
    public void testIsExpiredTrueBecauseOfRoot() {
        TicketGrantingTicketImpl t = new TicketGrantingTicketImpl("test", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        ServiceTicket s = t.grantServiceTicket(this.uniqueTicketIdGenerator.getNewTicketId("ST"), TestUtils.getService(), (ExpirationPolicy)new NeverExpiresExpirationPolicy(), false);
        t.markTicketExpired();
        Assert.assertTrue((boolean)s.isExpired());
    }

    @Test
    public void testIsExpiredFalse() {
        TicketGrantingTicketImpl t = new TicketGrantingTicketImpl("test", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        ServiceTicket s = t.grantServiceTicket(this.uniqueTicketIdGenerator.getNewTicketId("ST"), TestUtils.getService(), (ExpirationPolicy)new MultiTimeUseOrTimeoutExpirationPolicy(1, 5000L), false);
        Assert.assertFalse((boolean)s.isExpired());
    }

    @Test
    public void testTicketGrantingTicket() {
        Authentication a = TestUtils.getAuthentication();
        TicketGrantingTicketImpl t = new TicketGrantingTicketImpl("test", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        ServiceTicket s = t.grantServiceTicket(this.uniqueTicketIdGenerator.getNewTicketId("ST"), TestUtils.getService(), (ExpirationPolicy)new MultiTimeUseOrTimeoutExpirationPolicy(1, 5000L), false);
        TicketGrantingTicket t1 = s.grantTicketGrantingTicket(this.uniqueTicketIdGenerator.getNewTicketId("TGT"), a, (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        Assert.assertEquals((Object)a, (Object)t1.getAuthentication());
    }

    @Test
    public void testTicketGrantingTicketGrantedTwice() {
        Authentication a = TestUtils.getAuthentication();
        TicketGrantingTicketImpl t = new TicketGrantingTicketImpl("test", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        ServiceTicket s = t.grantServiceTicket(this.uniqueTicketIdGenerator.getNewTicketId("ST"), TestUtils.getService(), (ExpirationPolicy)new MultiTimeUseOrTimeoutExpirationPolicy(1, 5000L), false);
        s.grantTicketGrantingTicket(this.uniqueTicketIdGenerator.getNewTicketId("TGT"), a, (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        try {
            s.grantTicketGrantingTicket(this.uniqueTicketIdGenerator.getNewTicketId("TGT"), a, (ExpirationPolicy)new NeverExpiresExpirationPolicy());
            Assert.fail((String)"Exception expected.");
        }
        catch (Exception e) {
            return;
        }
    }
}

