/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.proxy.support;

import java.net.URL;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HttpBasedServiceCredential;
import org.jasig.cas.ticket.proxy.support.Cas20ProxyHandler;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.jasig.cas.util.HttpClient;
import org.jasig.cas.util.SimpleHttpClient;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Cas20ProxyHandlerTests {
    private Cas20ProxyHandler handler;

    @Before
    public void setUp() throws Exception {
        this.handler = new Cas20ProxyHandler();
        this.handler.setHttpClient((HttpClient)new SimpleHttpClient());
        this.handler.setUniqueTicketIdGenerator((UniqueTicketIdGenerator)new DefaultUniqueTicketIdGenerator());
    }

    @Test
    public void testValidProxyTicketWithoutQueryString() throws Exception {
        Assert.assertNotNull((Object)this.handler.handle((Credential)new HttpBasedServiceCredential(new URL("http://www.rutgers.edu/")), "proxyGrantingTicketId"));
    }

    @Test
    public void testValidProxyTicketWithQueryString() throws Exception {
        Assert.assertNotNull((Object)this.handler.handle((Credential)new HttpBasedServiceCredential(new URL("http://www.rutgers.edu/?test=test")), "proxyGrantingTicketId"));
    }

    @Test
    public void testNonValidProxyTicket() throws Exception {
        SimpleHttpClient httpClient = new SimpleHttpClient();
        httpClient.setAcceptableCodes(new int[]{900});
        this.handler.setHttpClient((HttpClient)httpClient);
        Assert.assertNull((Object)this.handler.handle((Credential)new HttpBasedServiceCredential(new URL("http://www.rutgers.edu")), "proxyGrantingTicketId"));
    }
}

