/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.ArrayList;
import java.util.Collection;
import org.jasig.cas.TestUtils;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.ticket.support.NeverExpiresExpirationPolicy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractTicketRegistryTests {
    private static final int TICKETS_IN_REGISTRY = 10;
    private TicketRegistry ticketRegistry;

    @Before
    public void setUp() throws Exception {
        this.ticketRegistry = this.getNewTicketRegistry();
    }

    public abstract TicketRegistry getNewTicketRegistry() throws Exception;

    @Test
    public void testAddTicketToCache() {
        try {
            this.ticketRegistry.addTicket((Ticket)new TicketGrantingTicketImpl("TEST", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy()));
        }
        catch (Exception e) {
            Assert.fail((String)"Caught an exception. But no exception should have been thrown.");
        }
    }

    @Test
    public void testGetNullTicket() {
        try {
            this.ticketRegistry.getTicket(null, TicketGrantingTicket.class);
        }
        catch (Exception e) {
            Assert.fail((String)"Exception caught.  None expected.");
        }
    }

    @Test
    public void testGetNonExistingTicket() {
        try {
            this.ticketRegistry.getTicket("FALALALALALAL", TicketGrantingTicket.class);
        }
        catch (Exception e) {
            Assert.fail((String)"Exception caught.  None expected.");
        }
    }

    @Test
    public void testGetExistingTicketWithProperClass() {
        try {
            this.ticketRegistry.addTicket((Ticket)new TicketGrantingTicketImpl("TEST", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy()));
            this.ticketRegistry.getTicket("TEST", TicketGrantingTicket.class);
        }
        catch (Exception e) {
            Assert.fail((String)"Caught an exception. But no exception should have been thrown.");
        }
    }

    @Test
    public void testGetExistingTicketWithInproperClass() {
        try {
            this.ticketRegistry.addTicket((Ticket)new TicketGrantingTicketImpl("TEST", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy()));
            this.ticketRegistry.getTicket("TEST", ServiceTicket.class);
        }
        catch (ClassCastException e) {
            return;
        }
        Assert.fail((String)"ClassCastfinal Exception expected.");
    }

    @Test
    public void testGetNullTicketWithoutClass() {
        try {
            this.ticketRegistry.getTicket(null);
        }
        catch (Exception e) {
            Assert.fail((String)"Exception caught.  None expected.");
        }
    }

    @Test
    public void testGetNonExistingTicketWithoutClass() {
        try {
            this.ticketRegistry.getTicket("FALALALALALAL");
        }
        catch (Exception e) {
            Assert.fail((String)"Exception caught.  None expected.");
        }
    }

    @Test
    public void testGetExistingTicket() {
        try {
            this.ticketRegistry.addTicket((Ticket)new TicketGrantingTicketImpl("TEST", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy()));
            this.ticketRegistry.getTicket("TEST");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Caught an exception. But no exception should have been thrown.");
        }
    }

    @Test
    public void testDeleteExistingTicket() {
        try {
            this.ticketRegistry.addTicket((Ticket)new TicketGrantingTicketImpl("TEST", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy()));
            Assert.assertTrue((String)"Ticket was not deleted.", (boolean)this.ticketRegistry.deleteTicket("TEST"));
        }
        catch (Exception e) {
            Assert.fail((String)"Caught an exception. But no exception should have been thrown.");
        }
    }

    @Test
    public void testDeleteNonExistingTicket() {
        try {
            this.ticketRegistry.addTicket((Ticket)new TicketGrantingTicketImpl("TEST", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy()));
            Assert.assertFalse((String)"Ticket was deleted.", (boolean)this.ticketRegistry.deleteTicket("TEST1"));
        }
        catch (Exception e) {
            Assert.fail((String)"Caught an exception. But no exception should have been thrown.");
        }
    }

    @Test
    public void testDeleteNullTicket() {
        try {
            this.ticketRegistry.addTicket((Ticket)new TicketGrantingTicketImpl("TEST", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy()));
            Assert.assertFalse((String)"Ticket was deleted.", (boolean)this.ticketRegistry.deleteTicket(null));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Caught an exception. But no exception should have been thrown.");
        }
    }

    @Test
    public void testGetTicketsIsZero() {
        try {
            Assert.assertEquals((String)"The size of the empty registry is not zero.", (long)this.ticketRegistry.getTickets().size(), (long)0L);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Caught an exception. But no exception should have been thrown.");
        }
    }

    @Test
    public void testGetTicketsFromRegistryEqualToTicketsAdded() {
        ArrayList<Object> tickets = new ArrayList<Object>();
        for (int i = 0; i < 10; ++i) {
            TicketGrantingTicketImpl ticketGrantingTicket = new TicketGrantingTicketImpl("TEST" + i, TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
            ServiceTicket serviceTicket = ticketGrantingTicket.grantServiceTicket("tests" + i, TestUtils.getService(), (ExpirationPolicy)new NeverExpiresExpirationPolicy(), false);
            tickets.add(ticketGrantingTicket);
            tickets.add(serviceTicket);
            this.ticketRegistry.addTicket((Ticket)ticketGrantingTicket);
            this.ticketRegistry.addTicket((Ticket)serviceTicket);
        }
        try {
            Collection ticketRegistryTickets = this.ticketRegistry.getTickets();
            Assert.assertEquals((String)"The size of the registry is not the same as the collection.", (long)ticketRegistryTickets.size(), (long)tickets.size());
            for (Ticket ticket : tickets) {
                if (ticketRegistryTickets.contains(ticket)) continue;
                Assert.fail((String)"Ticket was added to registry but was not found in retrieval of collection of all tickets.");
            }
        }
        catch (Exception e) {
            Assert.fail((String)"Caught an exception. But no exception should have been thrown.");
        }
    }
}

