/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.support;

import org.jasig.cas.TestUtils;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.support.ThrottledUseAndTimeoutExpirationPolicy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ThrottledUseAndTimeoutExpirationPolicyTests {
    private static final long TIMEOUT = 50L;
    private static final long TIMEOUT_BUFFER = 10L;
    private ThrottledUseAndTimeoutExpirationPolicy expirationPolicy;
    private TicketGrantingTicket ticket;

    @Before
    public void setUp() throws Exception {
        this.expirationPolicy = new ThrottledUseAndTimeoutExpirationPolicy();
        this.expirationPolicy.setTimeToKillInMilliSeconds(50L);
        this.expirationPolicy.setTimeInBetweenUsesInMilliSeconds(10L);
        this.ticket = new TicketGrantingTicketImpl("test", TestUtils.getAuthentication(), (ExpirationPolicy)this.expirationPolicy);
    }

    @Test
    public void testTicketIsNotExpired() {
        Assert.assertFalse((boolean)this.ticket.isExpired());
    }

    @Test
    public void testTicketIsExpired() throws InterruptedException {
        Thread.sleep(60L);
        Assert.assertTrue((boolean)this.ticket.isExpired());
    }

    @Test
    public void testTicketUsedButWithTimeout() throws InterruptedException {
        this.ticket.grantServiceTicket("test", TestUtils.getService(), (ExpirationPolicy)this.expirationPolicy, false);
        Thread.sleep(40L);
        Assert.assertFalse((boolean)this.ticket.isExpired());
    }

    @Test
    public void testNotWaitingEnoughTime() {
        this.ticket.grantServiceTicket("test", TestUtils.getService(), (ExpirationPolicy)this.expirationPolicy, false);
        Assert.assertTrue((boolean)this.ticket.isExpired());
    }
}

