/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.FileTrustStoreSslSocketFactory$CompositeX509KeyManager$AjcClosure1;
import org.jasig.cas.authentication.FileTrustStoreSslSocketFactory$CompositeX509KeyManager$AjcClosure11;
import org.jasig.cas.authentication.FileTrustStoreSslSocketFactory$CompositeX509KeyManager$AjcClosure3;
import org.jasig.cas.authentication.FileTrustStoreSslSocketFactory$CompositeX509KeyManager$AjcClosure5;
import org.jasig.cas.authentication.FileTrustStoreSslSocketFactory$CompositeX509KeyManager$AjcClosure7;
import org.jasig.cas.authentication.FileTrustStoreSslSocketFactory$CompositeX509KeyManager$AjcClosure9;
import org.jasig.cas.authentication.FileTrustStoreSslSocketFactory$CompositeX509TrustManager$AjcClosure1;
import org.jasig.cas.authentication.FileTrustStoreSslSocketFactory$CompositeX509TrustManager$AjcClosure3;
import org.jasig.cas.authentication.FileTrustStoreSslSocketFactory$CompositeX509TrustManager$AjcClosure5;
import org.jasig.cas.authentication.FileTrustStoreSslSocketFactory$DoesNotTrustStrategy$AjcClosure1;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileTrustStoreSslSocketFactory
extends SSLConnectionSocketFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTrustStoreSslSocketFactory.class);

    public FileTrustStoreSslSocketFactory(File trustStoreFile, String trustStorePassword) {
        this(trustStoreFile, trustStorePassword, KeyStore.getDefaultType());
    }

    public FileTrustStoreSslSocketFactory(File trustStoreFile, String trustStorePassword, String trustStoreType) {
        super(FileTrustStoreSslSocketFactory.getTrustedSslContext(trustStoreFile, trustStorePassword, trustStoreType));
    }

    private static SSLContext getTrustedSslContext(File trustStoreFile, String trustStorePassword, String trustStoreType) {
        try {
            if (!trustStoreFile.exists() || !trustStoreFile.canRead()) {
                throw new FileNotFoundException("Truststore file cannot be located at " + trustStoreFile.getCanonicalPath());
            }
            KeyStore casTrustStore = KeyStore.getInstance(trustStoreType);
            char[] trustStorePasswordCharArray = trustStorePassword.toCharArray();
            try (FileInputStream casStream = new FileInputStream(trustStoreFile);){
                casTrustStore.load(casStream, trustStorePasswordCharArray);
            }
            String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            X509KeyManager customKeyManager = FileTrustStoreSslSocketFactory.getKeyManager("PKIX", casTrustStore, trustStorePasswordCharArray);
            X509KeyManager jvmKeyManager = FileTrustStoreSslSocketFactory.getKeyManager(defaultAlgorithm, null, null);
            X509TrustManager customTrustManager = FileTrustStoreSslSocketFactory.getTrustManager("PKIX", casTrustStore);
            X509TrustManager jvmTrustManager = FileTrustStoreSslSocketFactory.getTrustManager(defaultAlgorithm, null);
            KeyManager[] keyManagers = new KeyManager[]{new CompositeX509KeyManager(Arrays.asList(jvmKeyManager, customKeyManager))};
            TrustManager[] trustManagers = new TrustManager[]{new CompositeX509TrustManager(Arrays.asList(jvmTrustManager, customTrustManager))};
            SSLContext context = SSLContexts.custom().useSSL().build();
            context.init(keyManagers, trustManagers, null);
            return context;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static X509KeyManager getKeyManager(String algorithm, KeyStore keystore, char[] password) throws Exception {
        KeyManagerFactory factory = KeyManagerFactory.getInstance(algorithm);
        factory.init(keystore, password);
        return (X509KeyManager)factory.getKeyManagers()[0];
    }

    private static X509TrustManager getTrustManager(String algorithm, KeyStore keystore) throws Exception {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(algorithm);
        factory.init(keystore);
        return (X509TrustManager)factory.getTrustManagers()[0];
    }

    private static class CompositeX509TrustManager
    implements X509TrustManager {
        private static final Logger LOGGER;
        private final List<X509TrustManager> trustManagers;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        public CompositeX509TrustManager(List<X509TrustManager> trustManagers) {
            this.trustManagers = trustManagers;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            X509Certificate[] x509CertificateArray = chain;
            String string = authType;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)x509CertificateArray, (Object)string);
            Object[] objectArray = new Object[]{this, x509CertificateArray, string, joinPoint};
            TraceLogAspect.aspectOf().traceMethod(new FileTrustStoreSslSocketFactory$CompositeX509TrustManager$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            X509Certificate[] x509CertificateArray = chain;
            String string = authType;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)x509CertificateArray, (Object)string);
            Object[] objectArray = new Object[]{this, x509CertificateArray, string, joinPoint};
            TraceLogAspect.aspectOf().traceMethod(new FileTrustStoreSslSocketFactory$CompositeX509TrustManager$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
            Object[] objectArray = new Object[]{this, joinPoint};
            return (X509Certificate[])TraceLogAspect.aspectOf().traceMethod(new FileTrustStoreSslSocketFactory$CompositeX509TrustManager$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }

        static {
            CompositeX509TrustManager.ajc$preClinit();
            LOGGER = LoggerFactory.getLogger(CompositeX509TrustManager.class);
        }

        static final /* synthetic */ void checkClientTrusted_aroundBody0(CompositeX509TrustManager ajc$this, X509Certificate[] chain, String authType, JoinPoint joinPoint) {
            for (X509TrustManager trustManager : ajc$this.trustManagers) {
                try {
                    trustManager.checkClientTrusted(chain, authType);
                    return;
                }
                catch (CertificateException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
            }
            throw new CertificateException("None of the TrustManagers trust this certificate chain");
        }

        static final /* synthetic */ void checkServerTrusted_aroundBody2(CompositeX509TrustManager ajc$this, X509Certificate[] chain, String authType, JoinPoint joinPoint) {
            for (X509TrustManager trustManager : ajc$this.trustManagers) {
                try {
                    trustManager.checkServerTrusted(chain, authType);
                    return;
                }
                catch (CertificateException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
            }
            throw new CertificateException("None of the TrustManagers trust this certificate chain");
        }

        static final /* synthetic */ X509Certificate[] getAcceptedIssuers_aroundBody4(CompositeX509TrustManager ajc$this, JoinPoint joinPoint) {
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            for (X509TrustManager trustManager : ajc$this.trustManagers) {
                List<X509Certificate> list = Arrays.asList(trustManager.getAcceptedIssuers());
                certificates.addAll(list);
            }
            return certificates.toArray(new X509Certificate[0]);
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("FileTrustStoreSslSocketFactory.java", CompositeX509TrustManager.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkClientTrusted", "org.jasig.cas.authentication.FileTrustStoreSslSocketFactory$CompositeX509TrustManager", "[Ljava.security.cert.X509Certificate;:java.lang.String", "chain:authType", "java.security.cert.CertificateException", "void"), 266);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkServerTrusted", "org.jasig.cas.authentication.FileTrustStoreSslSocketFactory$CompositeX509TrustManager", "[Ljava.security.cert.X509Certificate;:java.lang.String", "chain:authType", "java.security.cert.CertificateException", "void"), 279);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAcceptedIssuers", "org.jasig.cas.authentication.FileTrustStoreSslSocketFactory$CompositeX509TrustManager", "", "", "", "[Ljava.security.cert.X509Certificate;"), 292);
        }
    }

    private static class CompositeX509KeyManager
    implements X509KeyManager {
        private final List<X509KeyManager> keyManagers;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

        public CompositeX509KeyManager(List<X509KeyManager> keyManagers) {
            this.keyManagers = keyManagers;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            String[] stringArray = keyType;
            Principal[] principalArray = issuers;
            Socket socket2 = socket;
            Object[] objectArray = new Object[]{stringArray, principalArray, socket2};
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
            Object[] objectArray2 = new Object[]{this, stringArray, principalArray, socket2, joinPoint};
            return (String)TraceLogAspect.aspectOf().traceMethod(new FileTrustStoreSslSocketFactory$CompositeX509KeyManager$AjcClosure1(objectArray2).linkClosureAndJoinPoint(69648));
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            String string = keyType;
            Principal[] principalArray = issuers;
            Socket socket2 = socket;
            Object[] objectArray = new Object[]{string, principalArray, socket2};
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
            Object[] objectArray2 = new Object[]{this, string, principalArray, socket2, joinPoint};
            return (String)TraceLogAspect.aspectOf().traceMethod(new FileTrustStoreSslSocketFactory$CompositeX509KeyManager$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648));
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            String string = alias;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (PrivateKey)TraceLogAspect.aspectOf().traceMethod(new FileTrustStoreSslSocketFactory$CompositeX509KeyManager$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            String string = alias;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (X509Certificate[])TraceLogAspect.aspectOf().traceMethod(new FileTrustStoreSslSocketFactory$CompositeX509KeyManager$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            String string = keyType;
            Principal[] principalArray = issuers;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, (Object)principalArray);
            Object[] objectArray = new Object[]{this, string, principalArray, joinPoint};
            return (String[])TraceLogAspect.aspectOf().traceMethod(new FileTrustStoreSslSocketFactory$CompositeX509KeyManager$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            String string = keyType;
            Principal[] principalArray = issuers;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string, (Object)principalArray);
            Object[] objectArray = new Object[]{this, string, principalArray, joinPoint};
            return (String[])TraceLogAspect.aspectOf().traceMethod(new FileTrustStoreSslSocketFactory$CompositeX509KeyManager$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
        }

        static {
            CompositeX509KeyManager.ajc$preClinit();
        }

        static final /* synthetic */ String chooseClientAlias_aroundBody0(CompositeX509KeyManager ajc$this, String[] keyType, Principal[] issuers, Socket socket, JoinPoint joinPoint) {
            for (X509KeyManager keyManager : ajc$this.keyManagers) {
                String alias = keyManager.chooseClientAlias(keyType, issuers, socket);
                if (alias == null) continue;
                return alias;
            }
            return null;
        }

        static final /* synthetic */ String chooseServerAlias_aroundBody2(CompositeX509KeyManager ajc$this, String keyType, Principal[] issuers, Socket socket, JoinPoint joinPoint) {
            for (X509KeyManager keyManager : ajc$this.keyManagers) {
                String alias = keyManager.chooseServerAlias(keyType, issuers, socket);
                if (alias == null) continue;
                return alias;
            }
            return null;
        }

        static final /* synthetic */ PrivateKey getPrivateKey_aroundBody4(CompositeX509KeyManager ajc$this, String alias, JoinPoint joinPoint) {
            for (X509KeyManager keyManager : ajc$this.keyManagers) {
                PrivateKey privateKey = keyManager.getPrivateKey(alias);
                if (privateKey == null) continue;
                return privateKey;
            }
            return null;
        }

        static final /* synthetic */ X509Certificate[] getCertificateChain_aroundBody6(CompositeX509KeyManager ajc$this, String alias, JoinPoint joinPoint) {
            for (X509KeyManager keyManager : ajc$this.keyManagers) {
                X509Certificate[] chain = keyManager.getCertificateChain(alias);
                if (chain == null || chain.length <= 0) continue;
                return chain;
            }
            return null;
        }

        static final /* synthetic */ String[] getClientAliases_aroundBody8(CompositeX509KeyManager ajc$this, String keyType, Principal[] issuers, JoinPoint joinPoint) {
            ArrayList<String> aliases = new ArrayList<String>();
            for (X509KeyManager keyManager : ajc$this.keyManagers) {
                List<String> list = Arrays.asList(keyManager.getClientAliases(keyType, issuers));
                aliases.addAll(list);
            }
            return aliases.toArray(new String[0]);
        }

        static final /* synthetic */ String[] getServerAliases_aroundBody10(CompositeX509KeyManager ajc$this, String keyType, Principal[] issuers, JoinPoint joinPoint) {
            ArrayList<String> aliases = new ArrayList<String>();
            for (X509KeyManager keyManager : ajc$this.keyManagers) {
                List<String> list = Arrays.asList(keyManager.getServerAliases(keyType, issuers));
                aliases.addAll(list);
            }
            return aliases.toArray(new String[0]);
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("FileTrustStoreSslSocketFactory.java", CompositeX509KeyManager.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "chooseClientAlias", "org.jasig.cas.authentication.FileTrustStoreSslSocketFactory$CompositeX509KeyManager", "[Ljava.lang.String;:[Ljava.security.Principal;:java.net.Socket", "keyType:issuers:socket", "", "java.lang.String"), 178);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "chooseServerAlias", "org.jasig.cas.authentication.FileTrustStoreSslSocketFactory$CompositeX509KeyManager", "java.lang.String:[Ljava.security.Principal;:java.net.Socket", "keyType:issuers:socket", "", "java.lang.String"), 190);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPrivateKey", "org.jasig.cas.authentication.FileTrustStoreSslSocketFactory$CompositeX509KeyManager", "java.lang.String", "alias", "", "java.security.PrivateKey"), 202);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCertificateChain", "org.jasig.cas.authentication.FileTrustStoreSslSocketFactory$CompositeX509KeyManager", "java.lang.String", "alias", "", "[Ljava.security.cert.X509Certificate;"), 214);
            ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClientAliases", "org.jasig.cas.authentication.FileTrustStoreSslSocketFactory$CompositeX509KeyManager", "java.lang.String:[Ljava.security.Principal;", "keyType:issuers", "", "[Ljava.lang.String;"), 225);
            ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getServerAliases", "org.jasig.cas.authentication.FileTrustStoreSslSocketFactory$CompositeX509KeyManager", "java.lang.String:[Ljava.security.Principal;", "keyType:issuers", "", "[Ljava.lang.String;"), 235);
        }
    }

    private static class DoesNotTrustStrategy
    implements TrustStrategy {
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        private DoesNotTrustStrategy() {
        }

        public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            X509Certificate[] x509CertificateArray = x509Certificates;
            String string = s;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)x509CertificateArray, (Object)string);
            Object[] objectArray = new Object[]{this, x509CertificateArray, string, joinPoint};
            return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new FileTrustStoreSslSocketFactory$DoesNotTrustStrategy$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
        }

        static {
            DoesNotTrustStrategy.ajc$preClinit();
        }

        static final /* synthetic */ boolean isTrusted_aroundBody0(DoesNotTrustStrategy ajc$this, X509Certificate[] x509Certificates, String s, JoinPoint joinPoint) {
            return false;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("FileTrustStoreSslSocketFactory.java", DoesNotTrustStrategy.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isTrusted", "org.jasig.cas.authentication.FileTrustStoreSslSocketFactory$DoesNotTrustStrategy", "[Ljava.security.cert.X509Certificate;:java.lang.String", "x509Certificates:s", "java.security.cert.CertificateException", "boolean"), 160);
        }
    }
}

