/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository$AjcClosure1;
import org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository$AjcClosure11;
import org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository$AjcClosure13;
import org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository$AjcClosure15;
import org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository$AjcClosure17;
import org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository$AjcClosure3;
import org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository$AjcClosure5;
import org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository$AjcClosure7;
import org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository$AjcClosure9;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalAttributesRepository;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.merger.IAttributeMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CachingPrincipalAttributesRepository
implements PrincipalAttributesRepository,
Closeable {
    private static final long serialVersionUID = 6350244643948535906L;
    private static final TimeUnit DEFAULT_CACHE_EXPIRATION_UNIT;
    private static final long DEFAULT_CACHE_EXPIRATION_DURATION = 2L;
    private static final Logger LOGGER;
    private final IPersonAttributeDao attributeRepository;
    private final Cache<String, Map<String, Object>> cache;
    private final String cacheName = this.getClass().getSimpleName().concat(UUID.randomUUID().toString());
    private Duration duration;
    private IAttributeMerger mergingStrategy;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    private CachingPrincipalAttributesRepository() {
        this.attributeRepository = null;
        this.cache = null;
        this.duration = null;
    }

    public CachingPrincipalAttributesRepository(IPersonAttributeDao attributeRepository) {
        this(attributeRepository, 2L);
    }

    public CachingPrincipalAttributesRepository(IPersonAttributeDao attributeRepository, long expiryDuration) {
        this(attributeRepository, DEFAULT_CACHE_EXPIRATION_UNIT, expiryDuration);
    }

    public CachingPrincipalAttributesRepository(IPersonAttributeDao attributeRepository, TimeUnit timeUnit, long expiryDuration) {
        this(attributeRepository, new Duration(timeUnit, expiryDuration));
    }

    private CachingPrincipalAttributesRepository(IPersonAttributeDao attributeRepository, Duration duration) {
        this(attributeRepository, CachingPrincipalAttributesRepository.createCacheConfiguration(duration));
        this.duration = duration;
    }

    private CachingPrincipalAttributesRepository(IPersonAttributeDao attributeRepository, MutableConfiguration<String, Map<String, Object>> config) {
        this(attributeRepository, config, Caching.getCachingProvider().getCacheManager());
    }

    private CachingPrincipalAttributesRepository(IPersonAttributeDao attributeRepository, MutableConfiguration<String, Map<String, Object>> config, String cacheProviderFullClassName) {
        this(attributeRepository, config, Caching.getCachingProvider((String)cacheProviderFullClassName).getCacheManager());
    }

    private CachingPrincipalAttributesRepository(IPersonAttributeDao attributeRepository, MutableConfiguration<String, Map<String, Object>> config, CacheManager manager) {
        this.attributeRepository = attributeRepository;
        this.cache = manager.createCache(this.cacheName, config);
    }

    private CachingPrincipalAttributesRepository(IPersonAttributeDao attributeRepository, Cache<String, Map<String, Object>> cache) {
        this.attributeRepository = attributeRepository;
        this.cache = cache;
    }

    public IPersonAttributeDao getAttributeRepository() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (IPersonAttributeDao)TraceLogAspect.aspectOf().traceMethod(new CachingPrincipalAttributesRepository$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public Duration getDuration() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (Duration)TraceLogAspect.aspectOf().traceMethod(new CachingPrincipalAttributesRepository$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @JsonIgnore
    public MutableConfiguration<String, Map<String, Object>> getConfiguration() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (MutableConfiguration)TraceLogAspect.aspectOf().traceMethod(new CachingPrincipalAttributesRepository$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setMergingStrategy(IAttributeMerger mergingStrategy) {
        this.mergingStrategy = mergingStrategy;
    }

    public IAttributeMerger getMergingStrategy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (IAttributeMerger)TraceLogAspect.aspectOf().traceMethod(new CachingPrincipalAttributesRepository$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    protected static MutableConfiguration<String, Map<String, Object>> createCacheConfiguration(Duration expiryDuration) {
        MutableConfiguration config = new MutableConfiguration();
        config.setStatisticsEnabled(true);
        config.setManagementEnabled(true);
        config.setStoreByValue(true);
        config.setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((Duration)expiryDuration));
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPrincipalAttributesIntoCache(String id, Map<String, Object> attributes) {
        Cache<String, Map<String, Object>> cache = this.cache;
        synchronized (cache) {
            if (attributes.isEmpty()) {
                this.cache.remove((Object)id);
                LOGGER.debug("No attributes are provided, so removed principal id [{}] from the cache", (Object)id);
            } else {
                this.cache.put((Object)id, attributes);
                LOGGER.debug("Cached [{}] attributes for the principal id [{}]", (Object)attributes.size(), (Object)id);
            }
        }
    }

    public Map<String, Object> getAttributes(@NotNull Principal p) {
        Principal principal = p;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)principal);
        Object[] objectArray = new Object[]{this, principal, joinPoint};
        return (Map)TraceLogAspect.aspectOf().traceMethod(new CachingPrincipalAttributesRepository$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    private Map<String, List<Object>> convertPrincipalAttributesToPersonAttributes(Principal p) {
        HashMap<String, List<Object>> convertedAttributes = new HashMap<String, List<Object>>(p.getAttributes().size());
        Map principalAttributes = p.getAttributes();
        for (Map.Entry entry : principalAttributes.entrySet()) {
            Object values = entry.getValue();
            String key = (String)entry.getKey();
            if (values instanceof List) {
                convertedAttributes.put(key, (List)values);
                continue;
            }
            convertedAttributes.put(key, Collections.singletonList(values));
        }
        return convertedAttributes;
    }

    private Map<String, Object> convertPersonAttributesToPrincipalAttributes(Map<String, List<Object>> attributes) {
        HashMap<String, Object> convertedAttributes = new HashMap<String, Object>();
        for (Map.Entry<String, List<Object>> entry : attributes.entrySet()) {
            List<Object> values = entry.getValue();
            convertedAttributes.put(entry.getKey(), values.size() == 1 ? values.get(0) : values);
        }
        return convertedAttributes;
    }

    private Map<String, List<Object>> retrievePersonAttributesToPrincipalAttributes(String id) {
        IPersonAttributes attrs = this.attributeRepository.getPerson(id);
        if (attrs == null) {
            LOGGER.debug("Could not find principal [{}] in the repository so no attributes are returned.", (Object)id);
            return Collections.emptyMap();
        }
        Map attributes = attrs.getAttributes();
        if (attributes == null) {
            LOGGER.debug("Principal [{}] has no attributes and so none are returned.", (Object)id);
            return Collections.emptyMap();
        }
        return attributes;
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new CachingPrincipalAttributesRepository$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new CachingPrincipalAttributesRepository$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
    }

    public boolean equals(Object obj) {
        Object object = obj;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)object);
        Object[] objectArray = new Object[]{this, object, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new CachingPrincipalAttributesRepository$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public int hashCode() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.intValue((Object)TraceLogAspect.aspectOf().traceMethod(new CachingPrincipalAttributesRepository$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648)));
    }

    static {
        CachingPrincipalAttributesRepository.ajc$preClinit();
        DEFAULT_CACHE_EXPIRATION_UNIT = TimeUnit.HOURS;
        LOGGER = LoggerFactory.getLogger(CachingPrincipalAttributesRepository.class);
    }

    static final /* synthetic */ IPersonAttributeDao getAttributeRepository_aroundBody0(CachingPrincipalAttributesRepository ajc$this, JoinPoint joinPoint) {
        return ajc$this.attributeRepository;
    }

    static final /* synthetic */ Duration getDuration_aroundBody2(CachingPrincipalAttributesRepository ajc$this, JoinPoint joinPoint) {
        return ajc$this.duration;
    }

    static final /* synthetic */ MutableConfiguration getConfiguration_aroundBody4(CachingPrincipalAttributesRepository ajc$this, JoinPoint joinPoint) {
        return (MutableConfiguration)ajc$this.cache.getConfiguration(MutableConfiguration.class);
    }

    static final /* synthetic */ IAttributeMerger getMergingStrategy_aroundBody6(CachingPrincipalAttributesRepository ajc$this, JoinPoint joinPoint) {
        return ajc$this.mergingStrategy;
    }

    static final /* synthetic */ Map getAttributes_aroundBody8(CachingPrincipalAttributesRepository ajc$this, Principal p, JoinPoint joinPoint) {
        Map cachedAttributes = (Map)ajc$this.cache.get((Object)p.getId());
        if (cachedAttributes != null) {
            LOGGER.debug("Found [{}] cached attributes for principal [{}]", (Object)cachedAttributes.size(), (Object)p.getId());
            return cachedAttributes;
        }
        Map<String, List<Object>> sourceAttributes = ajc$this.retrievePersonAttributesToPrincipalAttributes(p.getId());
        LOGGER.debug("Found [{}] attributes for principal [{}] from the attribute repository.", (Object)sourceAttributes.size(), (Object)p.getId());
        if (ajc$this.mergingStrategy == null) {
            LOGGER.debug("No merging strategy found, so attributes retrieved from the repository will be used instead.");
            Map<String, Object> finalAttributes = ajc$this.convertPersonAttributesToPrincipalAttributes(sourceAttributes);
            ajc$this.addPrincipalAttributesIntoCache(p.getId(), finalAttributes);
            return finalAttributes;
        }
        Map<String, List<Object>> principalAttributes = ajc$this.convertPrincipalAttributesToPersonAttributes(p);
        LOGGER.debug("Merging current principal attributes with that of the repository via strategy [{}]", (Object)ajc$this.mergingStrategy.getClass().getSimpleName());
        Map mergedAttributes = ajc$this.mergingStrategy.mergeAttributes(principalAttributes, sourceAttributes);
        Map<String, Object> finalAttributes = ajc$this.convertPersonAttributesToPrincipalAttributes(mergedAttributes);
        ajc$this.addPrincipalAttributesIntoCache(p.getId(), finalAttributes);
        return finalAttributes;
    }

    static final /* synthetic */ void close_aroundBody10(CachingPrincipalAttributesRepository ajc$this, JoinPoint joinPoint) {
        ajc$this.cache.close();
        ajc$this.cache.getCacheManager().close();
    }

    static final /* synthetic */ String toString_aroundBody12(CachingPrincipalAttributesRepository ajc$this, JoinPoint joinPoint) {
        return new ToStringBuilder((Object)ajc$this).append("attributeRepository", (Object)ajc$this.attributeRepository).append("cache", ajc$this.cache).append("cacheName", (Object)ajc$this.cacheName).append("durationTimeUnit", (Object)ajc$this.duration.getTimeUnit()).append("durationAmount", ajc$this.duration.getDurationAmount()).append("mergingStrategy", (Object)ajc$this.mergingStrategy).toString();
    }

    static final /* synthetic */ boolean equals_aroundBody14(CachingPrincipalAttributesRepository ajc$this, Object obj, JoinPoint joinPoint) {
        if (obj == null) {
            return false;
        }
        if (obj == ajc$this) {
            return true;
        }
        if (obj.getClass() != ajc$this.getClass()) {
            return false;
        }
        CachingPrincipalAttributesRepository rhs = (CachingPrincipalAttributesRepository)obj;
        EqualsBuilder builder = new EqualsBuilder();
        return builder.append((Object)ajc$this.duration, (Object)rhs.duration).isEquals();
    }

    static final /* synthetic */ int hashCode_aroundBody16(CachingPrincipalAttributesRepository ajc$this, JoinPoint joinPoint) {
        return new HashCodeBuilder(13, 133).append((Object)ajc$this.duration).toHashCode();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CachingPrincipalAttributesRepository.java", CachingPrincipalAttributesRepository.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttributeRepository", "org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository", "", "", "", "org.jasig.services.persondir.IPersonAttributeDao"), 189);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDuration", "org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository", "", "", "", "javax.cache.expiry.Duration"), 193);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConfiguration", "org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository", "", "", "", "javax.cache.configuration.MutableConfiguration"), 203);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMergingStrategy", "org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository", "", "", "", "org.jasig.services.persondir.support.merger.IAttributeMerger"), 217);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttributes", "org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository", "org.jasig.cas.authentication.principal.Principal", "p", "", "java.util.Map"), 255);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "close", "org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository", "", "", "java.io.IOException", "void"), 346);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository", "", "", "", "java.lang.String"), 359);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "equals", "org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository", "java.lang.Object", "obj", "", "boolean"), 372);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hashCode", "org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository", "", "", "", "int"), 390);
    }
}

