/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.jasig.cas.authentication.principal.PersonDirectoryPrincipalResolver$AjcClosure1;
import org.jasig.cas.authentication.principal.PersonDirectoryPrincipalResolver$AjcClosure3;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalFactory;
import org.jasig.cas.authentication.principal.PrincipalResolver;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.StubPersonAttributeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonDirectoryPrincipalResolver
implements PrincipalResolver {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean returnNullIfNoAttributes;
    @NotNull
    private IPersonAttributeDao attributeRepository = new StubPersonAttributeDao(new HashMap());
    @NotNull
    private PrincipalFactory principalFactory = new DefaultPrincipalFactory();
    private String principalAttributeName;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public boolean supports(Credential credential) {
        Credential credential2 = credential;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)credential2);
        Object[] objectArray = new Object[]{this, credential2, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new PersonDirectoryPrincipalResolver$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public final Principal resolve(Credential credential) {
        Credential credential2 = credential;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)credential2);
        Object[] objectArray = new Object[]{this, credential2, joinPoint};
        return (Principal)TraceLogAspect.aspectOf().traceMethod(new PersonDirectoryPrincipalResolver$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    public final void setAttributeRepository(IPersonAttributeDao attributeRepository) {
        this.attributeRepository = attributeRepository;
    }

    public void setReturnNullIfNoAttributes(boolean returnNullIfNoAttributes) {
        this.returnNullIfNoAttributes = returnNullIfNoAttributes;
    }

    public void setPrincipalAttributeName(String attribute) {
        this.principalAttributeName = attribute;
    }

    public void setPrincipalFactory(PrincipalFactory principalFactory) {
        this.principalFactory = principalFactory;
    }

    protected String extractPrincipalId(Credential credential) {
        return credential.getId();
    }

    static {
        PersonDirectoryPrincipalResolver.ajc$preClinit();
    }

    static final /* synthetic */ boolean supports_aroundBody0(PersonDirectoryPrincipalResolver ajc$this, Credential credential, JoinPoint joinPoint) {
        return true;
    }

    static final /* synthetic */ Principal resolve_aroundBody2(PersonDirectoryPrincipalResolver ajc$this, Credential credential, JoinPoint joinPoint) {
        ajc$this.logger.debug("Attempting to resolve a principal...");
        String principalId = ajc$this.extractPrincipalId(credential);
        if (principalId == null) {
            ajc$this.logger.debug("Got null for extracted principal ID; returning null.");
            return null;
        }
        ajc$this.logger.debug("Creating SimplePrincipal for [{}]", (Object)principalId);
        IPersonAttributes personAttributes = ajc$this.attributeRepository.getPerson(principalId);
        Map attributes = personAttributes == null ? null : personAttributes.getAttributes();
        if (attributes == null & !ajc$this.returnNullIfNoAttributes) {
            return ajc$this.principalFactory.createPrincipal(principalId);
        }
        if (attributes == null) {
            return null;
        }
        HashMap<String, List> convertedAttributes = new HashMap<String, List>();
        for (Map.Entry entry : attributes.entrySet()) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            if (key.equalsIgnoreCase(ajc$this.principalAttributeName)) {
                if (values.isEmpty()) {
                    ajc$this.logger.debug("{} is empty, using {} for principal", (Object)ajc$this.principalAttributeName, (Object)principalId);
                    continue;
                }
                principalId = values.get(0).toString();
                ajc$this.logger.debug("Found principal attribute value {}; removing {} from attribute map.", (Object)principalId, (Object)ajc$this.principalAttributeName);
                continue;
            }
            convertedAttributes.put(key, (List)(values.size() == 1 ? values.get(0) : values));
        }
        return ajc$this.principalFactory.createPrincipal(principalId, convertedAttributes);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PersonDirectoryPrincipalResolver.java", PersonDirectoryPrincipalResolver.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supports", "org.jasig.cas.authentication.principal.PersonDirectoryPrincipalResolver", "org.jasig.cas.authentication.Credential", "credential", "", "boolean"), 64);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "resolve", "org.jasig.cas.authentication.principal.PersonDirectoryPrincipalResolver", "org.jasig.cas.authentication.Credential", "credential", "", "org.jasig.cas.authentication.principal.Principal"), 69);
    }
}

