/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.monitor.Monitor;
import org.jasig.cas.monitor.SessionMonitor$AjcClosure1;
import org.jasig.cas.monitor.SessionMonitor$AjcClosure3;
import org.jasig.cas.monitor.SessionStatus;
import org.jasig.cas.monitor.StatusCode;
import org.jasig.cas.monitor.TicketRegistryState;
import org.jasig.inspektr.aspect.TraceLogAspect;

public class SessionMonitor
implements Monitor<SessionStatus> {
    @NotNull
    private TicketRegistryState registryState;
    private int sessionCountWarnThreshold = -1;
    private int serviceTicketCountWarnThreshold = -1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public void setTicketRegistry(TicketRegistryState state) {
        this.registryState = state;
    }

    public void setSessionCountWarnThreshold(int threshold) {
        this.sessionCountWarnThreshold = threshold;
    }

    public void setServiceTicketCountWarnThreshold(int threshold) {
        this.serviceTicketCountWarnThreshold = threshold;
    }

    public String getName() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new SessionMonitor$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public SessionStatus observe() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (SessionStatus)((Object)TraceLogAspect.aspectOf().traceMethod(new SessionMonitor$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648)));
    }

    static {
        SessionMonitor.ajc$preClinit();
    }

    static final /* synthetic */ String getName_aroundBody0(SessionMonitor ajc$this, JoinPoint joinPoint) {
        return SessionMonitor.class.getSimpleName();
    }

    static final /* synthetic */ SessionStatus observe_aroundBody2(SessionMonitor ajc$this, JoinPoint joinPoint) {
        try {
            int sessionCount = ajc$this.registryState.sessionCount();
            int ticketCount = ajc$this.registryState.serviceTicketCount();
            if (sessionCount == Integer.MIN_VALUE || ticketCount == Integer.MIN_VALUE) {
                return new SessionStatus(StatusCode.UNKNOWN, String.format("Ticket registry %s reports unknown session and/or ticket counts.", ajc$this.registryState.getClass().getName()), sessionCount, ticketCount);
            }
            StringBuilder msg = new StringBuilder();
            StatusCode code = StatusCode.OK;
            if (ajc$this.sessionCountWarnThreshold > -1 && sessionCount > ajc$this.sessionCountWarnThreshold) {
                code = StatusCode.WARN;
                msg.append(String.format("Session count (%s) is above threshold %s. ", sessionCount, ajc$this.sessionCountWarnThreshold));
            } else {
                msg.append(sessionCount).append(" sessions. ");
            }
            if (ajc$this.serviceTicketCountWarnThreshold > -1 && ticketCount > ajc$this.serviceTicketCountWarnThreshold) {
                code = StatusCode.WARN;
                msg.append(String.format("Service ticket count (%s) is above threshold %s.", ticketCount, ajc$this.serviceTicketCountWarnThreshold));
            } else {
                msg.append(ticketCount).append(" service tickets.");
            }
            return new SessionStatus(code, msg.toString(), sessionCount, ticketCount);
        }
        catch (Exception e) {
            return new SessionStatus(StatusCode.ERROR, e.getMessage());
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SessionMonitor.java", SessionMonitor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getName", "org.jasig.cas.monitor.SessionMonitor", "", "", "", "java.lang.String"), 77);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "observe", "org.jasig.cas.monitor.SessionMonitor", "", "", "", "org.jasig.cas.monitor.SessionStatus"), 87);
    }
}

