/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.services.DefaultServicesManagerImpl$AjcClosure1;
import org.jasig.cas.services.DefaultServicesManagerImpl$AjcClosure11;
import org.jasig.cas.services.DefaultServicesManagerImpl$AjcClosure13;
import org.jasig.cas.services.DefaultServicesManagerImpl$AjcClosure3;
import org.jasig.cas.services.DefaultServicesManagerImpl$AjcClosure5;
import org.jasig.cas.services.DefaultServicesManagerImpl$AjcClosure7;
import org.jasig.cas.services.DefaultServicesManagerImpl$AjcClosure9;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ReloadableServicesManager;
import org.jasig.cas.services.ServiceRegistryDao;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.jasig.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public final class DefaultServicesManagerImpl
implements ReloadableServicesManager {
    private static final Logger LOGGER;
    @NotNull
    private final ServiceRegistryDao serviceRegistryDao;
    private ConcurrentHashMap<Long, RegisteredService> services = new ConcurrentHashMap();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public DefaultServicesManagerImpl(ServiceRegistryDao serviceRegistryDao) {
        this.serviceRegistryDao = serviceRegistryDao;
        this.load();
    }

    @Deprecated
    public DefaultServicesManagerImpl(ServiceRegistryDao serviceRegistryDao, List<String> defaultAttributes) {
        this(serviceRegistryDao);
        LOGGER.warn("This constructor is deprecated and will be removed in future CAS versions");
    }

    @Transactional(readOnly=false)
    @Audit(action="DELETE_SERVICE", actionResolverName="DELETE_SERVICE_ACTION_RESOLVER", resourceResolverName="DELETE_SERVICE_RESOURCE_RESOLVER")
    public synchronized RegisteredService delete(long id) {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        return (RegisteredService)TraceLogAspect.aspectOf().traceMethod(new DefaultServicesManagerImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public RegisteredService findServiceBy(Service service) {
        Service service2 = service;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)service2);
        Object[] objectArray = new Object[]{this, service2, joinPoint};
        return (RegisteredService)TraceLogAspect.aspectOf().traceMethod(new DefaultServicesManagerImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    public RegisteredService findServiceBy(long id) {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        return (RegisteredService)TraceLogAspect.aspectOf().traceMethod(new DefaultServicesManagerImpl$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    protected TreeSet<RegisteredService> convertToTreeSet() {
        return new TreeSet<RegisteredService>(this.services.values());
    }

    public Collection<RegisteredService> getAllServices() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (Collection)TraceLogAspect.aspectOf().traceMethod(new DefaultServicesManagerImpl$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    public boolean matchesExistingService(Service service) {
        Service service2 = service;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)service2);
        Object[] objectArray = new Object[]{this, service2, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new DefaultServicesManagerImpl$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @Transactional(readOnly=false)
    @Audit(action="SAVE_SERVICE", actionResolverName="SAVE_SERVICE_ACTION_RESOLVER", resourceResolverName="SAVE_SERVICE_RESOURCE_RESOLVER")
    public synchronized RegisteredService save(RegisteredService registeredService) {
        RegisteredService registeredService2 = registeredService;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)registeredService2);
        Object[] objectArray = new Object[]{this, registeredService2, joinPoint};
        return (RegisteredService)TraceLogAspect.aspectOf().traceMethod(new DefaultServicesManagerImpl$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void reload() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new DefaultServicesManagerImpl$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
    }

    private void load() {
        ConcurrentHashMap<Long, RegisteredService> localServices = new ConcurrentHashMap<Long, RegisteredService>();
        for (RegisteredService r : this.serviceRegistryDao.load()) {
            LOGGER.debug("Adding registered service {}", (Object)r.getServiceId());
            localServices.put(r.getId(), r);
        }
        this.services = localServices;
        LOGGER.info("Loaded {} services.", (Object)this.services.size());
    }

    static {
        DefaultServicesManagerImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(DefaultServicesManagerImpl.class);
    }

    static final /* synthetic */ RegisteredService delete_aroundBody0(DefaultServicesManagerImpl ajc$this, long id, JoinPoint joinPoint) {
        RegisteredService r = ajc$this.findServiceBy(id);
        if (r == null) {
            return null;
        }
        ajc$this.serviceRegistryDao.delete(r);
        ajc$this.services.remove(id);
        return r;
    }

    static final /* synthetic */ RegisteredService findServiceBy_aroundBody2(DefaultServicesManagerImpl ajc$this, Service service, JoinPoint joinPoint) {
        TreeSet<RegisteredService> c = ajc$this.convertToTreeSet();
        for (RegisteredService r : c) {
            if (!r.matches(service)) continue;
            return r;
        }
        return null;
    }

    static final /* synthetic */ RegisteredService findServiceBy_aroundBody4(DefaultServicesManagerImpl ajc$this, long id, JoinPoint joinPoint) {
        RegisteredService r = ajc$this.services.get(id);
        try {
            return r == null ? null : r.clone();
        }
        catch (CloneNotSupportedException e) {
            return r;
        }
    }

    static final /* synthetic */ Collection getAllServices_aroundBody6(DefaultServicesManagerImpl ajc$this, JoinPoint joinPoint) {
        return Collections.unmodifiableCollection(ajc$this.convertToTreeSet());
    }

    static final /* synthetic */ boolean matchesExistingService_aroundBody8(DefaultServicesManagerImpl ajc$this, Service service, JoinPoint joinPoint) {
        return ajc$this.findServiceBy(service) != null;
    }

    static final /* synthetic */ RegisteredService save_aroundBody10(DefaultServicesManagerImpl ajc$this, RegisteredService registeredService, JoinPoint joinPoint) {
        RegisteredService r = ajc$this.serviceRegistryDao.save(registeredService);
        ajc$this.services.put(r.getId(), r);
        return r;
    }

    static final /* synthetic */ void reload_aroundBody12(DefaultServicesManagerImpl ajc$this, JoinPoint joinPoint) {
        LOGGER.info("Reloading registered services.");
        ajc$this.load();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DefaultServicesManagerImpl.java", DefaultServicesManagerImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "delete", "org.jasig.cas.services.DefaultServicesManagerImpl", "long", "id", "", "org.jasig.cas.services.RegisteredService"), 89);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findServiceBy", "org.jasig.cas.services.DefaultServicesManagerImpl", "org.jasig.cas.authentication.principal.Service", "service", "", "org.jasig.cas.services.RegisteredService"), 105);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findServiceBy", "org.jasig.cas.services.DefaultServicesManagerImpl", "long", "id", "", "org.jasig.cas.services.RegisteredService"), 118);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllServices", "org.jasig.cas.services.DefaultServicesManagerImpl", "", "", "", "java.util.Collection"), 137);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "matchesExistingService", "org.jasig.cas.services.DefaultServicesManagerImpl", "org.jasig.cas.authentication.principal.Service", "service", "", "boolean"), 142);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "save", "org.jasig.cas.services.DefaultServicesManagerImpl", "org.jasig.cas.services.RegisteredService", "registeredService", "", "org.jasig.cas.services.RegisteredService"), 150);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "reload", "org.jasig.cas.services.DefaultServicesManagerImpl", "", "", "", "void"), 157);
    }
}

