/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;
import org.slf4j.helpers.Util;
import org.slf4j.impl.CasDelegatingLogger;

public final class CasLoggerFactory
implements ILoggerFactory {
    private static final String PACKAGE_TO_SCAN = "org.slf4j.impl";
    private final Map<String, CasDelegatingLogger> loggerMap = new ConcurrentHashMap<String, CasDelegatingLogger>();
    private final Class<? extends ILoggerFactory> realLoggerFactoryClass;

    public CasLoggerFactory() {
        Collection set = ClasspathHelper.forPackage((String)PACKAGE_TO_SCAN, (ClassLoader[])new ClassLoader[0]);
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addUrls(set).setScanners(new Scanner[]{new SubTypesScanner()}));
        Set subTypesOf = reflections.getSubTypesOf(ILoggerFactory.class);
        subTypesOf.remove(this.getClass());
        if (subTypesOf.size() > 1) {
            Util.report((String)"Multiple ILoggerFactory bindings are found on the classpath:");
            for (Class c : subTypesOf) {
                Util.report((String)("* " + c.getCanonicalName()));
            }
        }
        if (subTypesOf.isEmpty()) {
            RuntimeException e = new RuntimeException("No ILoggerFactory could be found on the classpath. CAS cannot determine the logging framework. Examine the project dependencies and ensure that there is one and only one logging framework available.");
            Util.report((String)e.getMessage(), (Throwable)e);
            throw e;
        }
        this.realLoggerFactoryClass = (Class)subTypesOf.iterator().next();
        Util.report((String)("ILoggerFactory to be used for logging is: " + this.realLoggerFactoryClass.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLogger(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return NOPLogger.NOP_LOGGER;
        }
        Map<String, CasDelegatingLogger> map = this.loggerMap;
        synchronized (map) {
            if (!this.loggerMap.containsKey(name)) {
                Logger logger = this.getRealLoggerInstance(name);
                this.loggerMap.put(name, new CasDelegatingLogger(logger));
            }
            return (Logger)this.loggerMap.get(name);
        }
    }

    private Logger getRealLoggerInstance(String name) {
        try {
            ILoggerFactory factInstance = this.realLoggerFactoryClass.newInstance();
            return factInstance.getLogger(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

