/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationPolicy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="anyAuthenticationPolicy")
public class AnyAuthenticationPolicy
implements AuthenticationPolicy {
    private boolean tryAll;

    @Autowired
    public void setTryAll(@Value(value="${cas.authn.policy.any.tryall:false}") boolean tryAll) {
        this.tryAll = tryAll;
    }

    public boolean isSatisfiedBy(Authentication authn) {
        if (this.tryAll) {
            return authn.getCredentials().size() == authn.getSuccesses().size() + authn.getFailures().size();
        }
        return !authn.getSuccesses().isEmpty();
    }
}

