/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationBuilder;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.ImmutableAuthentication;
import org.jasig.cas.authentication.principal.Principal;
import org.joda.time.DateTime;
import org.springframework.util.Assert;

public class DefaultAuthenticationBuilder
implements AuthenticationBuilder {
    private static final long serialVersionUID = -8504842011648432398L;
    private Principal principal;
    private final List<CredentialMetaData> credentials = new ArrayList<CredentialMetaData>();
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private final Map<String, HandlerResult> successes = new LinkedHashMap<String, HandlerResult>();
    private final Map<String, Class<? extends Exception>> failures = new LinkedHashMap<String, Class<? extends Exception>>();
    private DateTime authenticationDate = new DateTime();

    public DefaultAuthenticationBuilder() {
    }

    public DefaultAuthenticationBuilder(Principal p) {
        this();
        this.principal = p;
    }

    public DateTime getAuthenticationDate() {
        return this.authenticationDate == null ? null : new DateTime((Object)this.authenticationDate);
    }

    public AuthenticationBuilder setAuthenticationDate(DateTime d) {
        this.authenticationDate = d;
        return this;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public AuthenticationBuilder addCredentials(List<CredentialMetaData> credentials) {
        this.credentials.addAll(credentials);
        return this;
    }

    public AuthenticationBuilder setPrincipal(Principal p) {
        this.principal = p;
        return this;
    }

    public List<CredentialMetaData> getCredentials() {
        return this.credentials;
    }

    public AuthenticationBuilder setCredentials(List<CredentialMetaData> credentials) {
        Assert.notNull(credentials, (String)"Credential cannot be null");
        this.credentials.clear();
        this.credentials.addAll(credentials);
        return this;
    }

    public AuthenticationBuilder addCredential(CredentialMetaData credential) {
        this.credentials.add(credential);
        return this;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public AuthenticationBuilder setAttributes(Map<String, Object> attributes) {
        Assert.notNull(attributes, (String)"Attributes cannot be null");
        this.attributes.clear();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            this.attributes.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public AuthenticationBuilder addAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public Map<String, HandlerResult> getSuccesses() {
        return this.successes;
    }

    public AuthenticationBuilder setSuccesses(Map<String, HandlerResult> successes) {
        Assert.notNull(successes, (String)"Successes cannot be null");
        this.successes.clear();
        return this.addSuccesses(successes);
    }

    public AuthenticationBuilder addSuccesses(Map<String, HandlerResult> successes) {
        for (Map.Entry<String, HandlerResult> entry : successes.entrySet()) {
            this.addSuccess(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public AuthenticationBuilder addSuccess(String key, HandlerResult value) {
        this.successes.put(key, value);
        return this;
    }

    public Map<String, Class<? extends Exception>> getFailures() {
        return this.failures;
    }

    public AuthenticationBuilder setFailures(Map<String, Class<? extends Exception>> failures) {
        Assert.notNull(failures, (String)"Failures cannot be null");
        this.failures.clear();
        return this.addFailures(failures);
    }

    public AuthenticationBuilder addFailures(Map<String, Class<? extends Exception>> failures) {
        for (Map.Entry<String, Class<? extends Exception>> entry : failures.entrySet()) {
            this.addFailure(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public AuthenticationBuilder addFailure(String key, Class<? extends Exception> value) {
        this.failures.put(key, value);
        return this;
    }

    public Authentication build() {
        return new ImmutableAuthentication(this.authenticationDate, this.credentials, this.principal, this.attributes, this.successes, this.failures);
    }

    public static AuthenticationBuilder newInstance(Authentication source) {
        DefaultAuthenticationBuilder builder = new DefaultAuthenticationBuilder(source.getPrincipal());
        builder.setAuthenticationDate(source.getAuthenticationDate());
        builder.setCredentials(source.getCredentials());
        builder.setSuccesses(source.getSuccesses());
        builder.setFailures(source.getFailures());
        builder.setAttributes(source.getAttributes());
        return builder;
    }

    public static AuthenticationBuilder newInstance() {
        return new DefaultAuthenticationBuilder();
    }
}

