/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.util.Collection;
import java.util.Map;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.PrincipalElectionStrategy;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="defaultPrincipalElectionStrategy")
public final class DefaultPrincipalElectionStrategy
implements PrincipalElectionStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPrincipalElectionStrategy.class);
    private static final long serialVersionUID = 6704726217030836315L;
    @Autowired
    @Qualifier(value="principalFactory")
    private PrincipalFactory principalFactory = new DefaultPrincipalFactory();

    public Principal nominate(Collection<Authentication> authentications, Map<String, Object> principalAttributes) {
        Principal principal = authentications.iterator().next().getPrincipal();
        Principal finalPrincipal = this.principalFactory.createPrincipal(principal.getId(), principalAttributes);
        LOGGER.debug("Nominated [{}] as the primary principal", (Object)finalPrincipal);
        return finalPrincipal;
    }

    public void setPrincipalFactory(PrincipalFactory principalFactory) {
        this.principalFactory = principalFactory;
    }
}

