/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="trustStoreSslSocketFactory")
public final class FileTrustStoreSslSocketFactory
extends SSLConnectionSocketFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTrustStoreSslSocketFactory.class);

    @Autowired
    public FileTrustStoreSslSocketFactory(@Value(value="${http.client.truststore.file:classpath:truststore.jks}") File trustStoreFile, @Value(value="${http.client.truststore.psw:changeit}") String trustStorePassword) {
        this(trustStoreFile, trustStorePassword, KeyStore.getDefaultType());
    }

    public FileTrustStoreSslSocketFactory(File trustStoreFile, String trustStorePassword, String trustStoreType) {
        super(FileTrustStoreSslSocketFactory.getTrustedSslContext(trustStoreFile, trustStorePassword, trustStoreType));
    }

    private static SSLContext getTrustedSslContext(File trustStoreFile, String trustStorePassword, String trustStoreType) {
        try {
            if (!trustStoreFile.exists() || !trustStoreFile.canRead()) {
                throw new FileNotFoundException("Truststore file cannot be located at " + trustStoreFile.getCanonicalPath());
            }
            KeyStore casTrustStore = KeyStore.getInstance(trustStoreType);
            char[] trustStorePasswordCharArray = trustStorePassword.toCharArray();
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileInputStream casStream = new FileInputStream(trustStoreFile);){
                casTrustStore.load(casStream, trustStorePasswordCharArray);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            X509KeyManager customKeyManager = FileTrustStoreSslSocketFactory.getKeyManager("PKIX", casTrustStore, trustStorePasswordCharArray);
            X509KeyManager jvmKeyManager = FileTrustStoreSslSocketFactory.getKeyManager(defaultAlgorithm, null, null);
            X509TrustManager customTrustManager = FileTrustStoreSslSocketFactory.getTrustManager("PKIX", casTrustStore);
            X509TrustManager jvmTrustManager = FileTrustStoreSslSocketFactory.getTrustManager(defaultAlgorithm, null);
            KeyManager[] keyManagers = new KeyManager[]{new CompositeX509KeyManager(Arrays.asList(jvmKeyManager, customKeyManager))};
            TrustManager[] trustManagers = new TrustManager[]{new CompositeX509TrustManager(Arrays.asList(jvmTrustManager, customTrustManager))};
            SSLContext context = SSLContexts.custom().useSSL().build();
            context.init(keyManagers, trustManagers, null);
            return context;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static X509KeyManager getKeyManager(String algorithm, KeyStore keystore, char[] password) throws Exception {
        KeyManagerFactory factory = KeyManagerFactory.getInstance(algorithm);
        factory.init(keystore, password);
        return (X509KeyManager)factory.getKeyManagers()[0];
    }

    private static X509TrustManager getTrustManager(String algorithm, KeyStore keystore) throws Exception {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(algorithm);
        factory.init(keystore);
        return (X509TrustManager)factory.getTrustManagers()[0];
    }

    private static class CompositeX509KeyManager
    implements X509KeyManager {
        private final List<X509KeyManager> keyManagers;

        CompositeX509KeyManager(List<X509KeyManager> keyManagers) {
            this.keyManagers = keyManagers;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            for (X509KeyManager keyManager : this.keyManagers) {
                String alias = keyManager.chooseClientAlias(keyType, issuers, socket);
                if (alias == null) continue;
                return alias;
            }
            return null;
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            for (X509KeyManager keyManager : this.keyManagers) {
                String alias = keyManager.chooseServerAlias(keyType, issuers, socket);
                if (alias == null) continue;
                return alias;
            }
            return null;
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            for (X509KeyManager keyManager : this.keyManagers) {
                PrivateKey privateKey = keyManager.getPrivateKey(alias);
                if (privateKey == null) continue;
                return privateKey;
            }
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            for (X509KeyManager keyManager : this.keyManagers) {
                X509Certificate[] chain = keyManager.getCertificateChain(alias);
                if (chain == null || chain.length <= 0) continue;
                return chain;
            }
            return null;
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            ArrayList<String> aliases = new ArrayList<String>();
            for (X509KeyManager keyManager : this.keyManagers) {
                List<String> list = Arrays.asList(keyManager.getClientAliases(keyType, issuers));
                aliases.addAll(list);
            }
            return aliases.toArray(new String[0]);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            ArrayList<String> aliases = new ArrayList<String>();
            for (X509KeyManager keyManager : this.keyManagers) {
                List<String> list = Arrays.asList(keyManager.getServerAliases(keyType, issuers));
                aliases.addAll(list);
            }
            return aliases.toArray(new String[0]);
        }
    }

    private static class CompositeX509TrustManager
    implements X509TrustManager {
        private static final Logger LOGGER = LoggerFactory.getLogger(CompositeX509TrustManager.class);
        private final List<X509TrustManager> trustManagers;

        CompositeX509TrustManager(List<X509TrustManager> trustManagers) {
            this.trustManagers = trustManagers;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            for (X509TrustManager trustManager : this.trustManagers) {
                try {
                    trustManager.checkClientTrusted(chain, authType);
                    return;
                }
                catch (CertificateException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
            }
            throw new CertificateException("None of the TrustManagers trust this certificate chain");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            for (X509TrustManager trustManager : this.trustManagers) {
                try {
                    trustManager.checkServerTrusted(chain, authType);
                    return;
                }
                catch (CertificateException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
            }
            throw new CertificateException("None of the TrustManagers trust this certificate chain");
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            for (X509TrustManager trustManager : this.trustManagers) {
                List<X509Certificate> list = Arrays.asList(trustManager.getAcceptedIssuers());
                certificates.addAll(list);
            }
            return certificates.toArray(new X509Certificate[0]);
        }
    }

    private static class DoesNotTrustStrategy
    implements TrustStrategy {
        private DoesNotTrustStrategy() {
        }

        public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            return false;
        }
    }
}

