/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import com.codahale.metrics.annotation.Counted;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.jasig.cas.authentication.AnyAuthenticationPolicy;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationBuilder;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.AuthenticationManager;
import org.jasig.cas.authentication.AuthenticationMetaDataPopulator;
import org.jasig.cas.authentication.AuthenticationPolicy;
import org.jasig.cas.authentication.AuthenticationTransaction;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.DefaultAuthenticationBuilder;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UnresolvedPrincipalException;
import org.jasig.cas.authentication.principal.NullPrincipal;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalResolver;
import org.jasig.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="authenticationManager")
public class PolicyBasedAuthenticationManager
implements AuthenticationManager {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<AuthenticationMetaDataPopulator> authenticationMetaDataPopulators = new ArrayList<AuthenticationMetaDataPopulator>();
    private AuthenticationPolicy authenticationPolicy = new AnyAuthenticationPolicy();
    @Resource(name="authenticationHandlersResolvers")
    private Map<AuthenticationHandler, PrincipalResolver> handlerResolverMap;

    protected PolicyBasedAuthenticationManager() {
    }

    public PolicyBasedAuthenticationManager(AuthenticationHandler ... handlers) {
        this(Arrays.asList(handlers));
    }

    public PolicyBasedAuthenticationManager(List<AuthenticationHandler> handlers) {
        Assert.notEmpty(handlers, (String)"At least one authentication handler is required");
        this.handlerResolverMap = new LinkedHashMap<AuthenticationHandler, PrincipalResolver>(handlers.size());
        for (AuthenticationHandler handler : handlers) {
            this.handlerResolverMap.put(handler, null);
        }
    }

    public PolicyBasedAuthenticationManager(Map<AuthenticationHandler, PrincipalResolver> map) {
        Assert.notEmpty(map, (String)"At least one authentication handler is required");
        this.handlerResolverMap = map;
    }

    @Audit(action="AUTHENTICATION", actionResolverName="AUTHENTICATION_RESOLVER", resourceResolverName="AUTHENTICATION_RESOURCE_RESOLVER")
    @Timed(name="AUTHENTICATE_TIMED")
    @Metered(name="AUTHENTICATE_METER")
    @Counted(name="AUTHENTICATE_COUNT", monotonic=true)
    public Authentication authenticate(AuthenticationTransaction transaction) throws AuthenticationException {
        AuthenticationBuilder builder = this.authenticateInternal(transaction.getCredentials());
        Authentication authentication = builder.build();
        Principal principal = authentication.getPrincipal();
        if (principal instanceof NullPrincipal) {
            throw new UnresolvedPrincipalException(authentication);
        }
        this.addAuthenticationMethodAttribute(builder, authentication);
        this.logger.info("Authenticated {} with credentials {}.", (Object)principal, (Object)transaction.getCredentials());
        this.logger.debug("Attribute map for {}: {}", (Object)principal.getId(), (Object)principal.getAttributes());
        this.populateAuthenticationMetadataAttributes(builder, transaction.getCredentials());
        return builder.build();
    }

    private void populateAuthenticationMetadataAttributes(AuthenticationBuilder builder, Collection<Credential> credentials) {
        for (AuthenticationMetaDataPopulator populator : this.authenticationMetaDataPopulators) {
            for (Credential credential : credentials) {
                if (!populator.supports(credential)) continue;
                populator.populateAttributes(builder, credential);
            }
        }
    }

    private void addAuthenticationMethodAttribute(AuthenticationBuilder builder, Authentication authentication) {
        for (HandlerResult result : authentication.getSuccesses().values()) {
            builder.addAttribute("authenticationMethod", (Object)result.getHandlerName());
        }
    }

    @Resource(name="authenticationMetadataPopulators")
    public final void setAuthenticationMetaDataPopulators(List<AuthenticationMetaDataPopulator> populators) {
        this.authenticationMetaDataPopulators = populators;
    }

    @Resource(name="authenticationPolicy")
    public void setAuthenticationPolicy(AuthenticationPolicy policy) {
        this.authenticationPolicy = policy;
    }

    protected AuthenticationBuilder authenticateInternal(Collection<Credential> credentials) throws AuthenticationException {
        DefaultAuthenticationBuilder builder = new DefaultAuthenticationBuilder(NullPrincipal.getInstance());
        for (Credential c : credentials) {
            builder.addCredential(new BasicCredentialMetaData(c));
        }
        for (Credential credential : credentials) {
            boolean found = false;
            for (Map.Entry<AuthenticationHandler, PrincipalResolver> entry : this.handlerResolverMap.entrySet()) {
                AuthenticationHandler handler = entry.getKey();
                if (!handler.supports(credential)) continue;
                found = true;
                try {
                    this.authenticateAndResolvePrincipal(builder, credential, entry.getValue(), handler);
                    if (!this.authenticationPolicy.isSatisfiedBy(builder.build())) continue;
                    return builder;
                }
                catch (GeneralSecurityException e) {
                    this.logger.info("{} failed authenticating {}", (Object)handler.getName(), (Object)credential);
                    this.logger.debug("{} exception details: {}", (Object)handler.getName(), (Object)e.getMessage());
                    builder.addFailure(handler.getName(), e.getClass());
                }
                catch (PreventedException e) {
                    this.logger.error("{}: {}  (Details: {})", new Object[]{handler.getName(), e.getMessage(), e.getCause().getMessage()});
                    builder.addFailure(handler.getName(), ((Object)((Object)e)).getClass());
                }
            }
            if (found) continue;
            this.logger.warn("Cannot find authentication handler that supports [{}] of type [{}], which suggests a configuration problem.", (Object)credential, (Object)credential.getClass().getSimpleName());
        }
        this.evaluateProducedAuthenticationContext(builder);
        return builder;
    }

    private void evaluateProducedAuthenticationContext(AuthenticationBuilder builder) throws AuthenticationException {
        if (builder.getSuccesses().isEmpty()) {
            throw new AuthenticationException(builder.getFailures(), builder.getSuccesses());
        }
        if (!this.authenticationPolicy.isSatisfiedBy(builder.build())) {
            throw new AuthenticationException(builder.getFailures(), builder.getSuccesses());
        }
    }

    private void authenticateAndResolvePrincipal(AuthenticationBuilder builder, Credential credential, PrincipalResolver resolver, AuthenticationHandler handler) throws GeneralSecurityException, PreventedException {
        Principal principal;
        HandlerResult result = handler.authenticate(credential);
        builder.addSuccess(handler.getName(), result);
        this.logger.info("{} successfully authenticated {}", (Object)handler.getName(), (Object)credential);
        if (resolver == null) {
            principal = result.getPrincipal();
            this.logger.debug("No resolver configured for {}. Falling back to handler principal {}", (Object)handler.getName(), (Object)principal);
        } else {
            principal = this.resolvePrincipal(handler.getName(), resolver, credential);
            if (principal == null) {
                this.logger.warn("Principal resolution handled by {} produced a null principal. This is likely due to misconfiguration or missing attributes; CAS will attempt to use the principal produced by the authentication handler, if any.", (Object)resolver.getClass().getSimpleName());
                principal = result.getPrincipal();
            }
        }
        if (principal != null) {
            builder.setPrincipal(principal);
        }
        this.logger.debug("Final principal resolved for this authentication event is {}", (Object)principal);
    }

    protected Principal resolvePrincipal(String handlerName, PrincipalResolver resolver, Credential credential) {
        if (resolver.supports(credential)) {
            try {
                Principal p = resolver.resolve(credential);
                this.logger.debug("{} resolved {} from {}", new Object[]{resolver, p, credential});
                return p;
            }
            catch (Exception e) {
                this.logger.error("{} failed to resolve principal from {}", new Object[]{resolver, credential, e});
            }
        } else {
            this.logger.warn("{} is configured to use {} but it does not support {}, which suggests a configuration problem.", new Object[]{handlerName, resolver, credential});
        }
        return null;
    }
}

