/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalFactory;
import org.jasig.cas.authentication.principal.PrincipalResolver;
import org.jasig.cas.util.Pair;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.StubPersonAttributeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="personDirectoryPrincipalResolver")
public class PersonDirectoryPrincipalResolver
implements PrincipalResolver {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    protected IPersonAttributeDao attributeRepository = new StubPersonAttributeDao(new HashMap());
    @NotNull
    protected PrincipalFactory principalFactory = new DefaultPrincipalFactory();
    @Value(value="${cas.principal.resolver.persondir.return.null:false}")
    protected boolean returnNullIfNoAttributes;
    protected String principalAttributeName;

    @Autowired
    public final void setAttributeRepository(@Qualifier(value="attributeRepository") IPersonAttributeDao attributeRepository) {
        this.attributeRepository = attributeRepository;
    }

    public void setReturnNullIfNoAttributes(boolean returnNullIfNoAttributes) {
        this.returnNullIfNoAttributes = returnNullIfNoAttributes;
    }

    @Autowired
    public void setPrincipalAttributeName(@Value(value="${cas.principal.resolver.persondir.principal.attribute:}") String attribute) {
        this.principalAttributeName = attribute;
    }

    @Autowired
    public void setPrincipalFactory(@Qualifier(value="principalFactory") PrincipalFactory principalFactory) {
        this.principalFactory = principalFactory;
    }

    public boolean supports(Credential credential) {
        return credential != null && credential.getId() != null;
    }

    public Principal resolve(Credential credential) {
        this.logger.debug("Attempting to resolve a principal...");
        String principalId = this.extractPrincipalId(credential);
        if (principalId == null) {
            this.logger.debug("Got null for extracted principal ID; returning null.");
            return null;
        }
        this.logger.debug("Creating SimplePrincipal for [{}]", (Object)principalId);
        Map<String, List<Object>> attributes = this.retrievePersonAttributes(principalId, credential);
        if (attributes == null || attributes.isEmpty()) {
            this.logger.debug("Principal id [{}] did not specify any attributes", (Object)principalId);
            if (!this.returnNullIfNoAttributes) {
                this.logger.debug("Returning the principal with id [{}] without any attributes", (Object)principalId);
                return this.principalFactory.createPrincipal(principalId);
            }
            this.logger.debug("[{}] is configured to return null if no attributes are found for [{}]", (Object)this.getClass().getName(), (Object)principalId);
            return null;
        }
        this.logger.debug("Retrieved [{}] attribute(s) from the repository", (Object)attributes.size());
        Pair<String, Map<String, Object>> pair = this.convertPersonAttributesToPrincipal(principalId, attributes);
        return this.principalFactory.createPrincipal((String)pair.getFirst(), (Map)pair.getSecond());
    }

    protected Pair<String, Map<String, Object>> convertPersonAttributesToPrincipal(String extractedPrincipalId, Map<String, List<Object>> attributes) {
        HashMap<String, Object> convertedAttributes = new HashMap<String, Object>();
        String principalId = extractedPrincipalId;
        for (Map.Entry<String, List<Object>> entry : attributes.entrySet()) {
            String key = entry.getKey();
            List<Object> values = entry.getValue();
            if (StringUtils.isNotBlank((CharSequence)this.principalAttributeName) && key.equalsIgnoreCase(this.principalAttributeName)) {
                if (values.isEmpty()) {
                    this.logger.debug("{} is empty, using {} for principal", (Object)this.principalAttributeName, (Object)extractedPrincipalId);
                    continue;
                }
                principalId = values.get(0).toString();
                this.logger.debug("Found principal attribute value {}; removing {} from attribute map.", (Object)extractedPrincipalId, (Object)this.principalAttributeName);
                continue;
            }
            convertedAttributes.put(key, values.size() == 1 ? values.get(0) : values);
        }
        return new Pair((Object)principalId, convertedAttributes);
    }

    protected Map<String, List<Object>> retrievePersonAttributes(String principalId, Credential credential) {
        IPersonAttributes personAttributes = this.attributeRepository.getPerson(principalId);
        Map attributes = personAttributes == null ? null : personAttributes.getAttributes();
        return attributes;
    }

    protected String extractPrincipalId(Credential credential) {
        return credential.getId();
    }
}

