/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import org.jasig.cas.authentication.AuthenticationBuilder;
import org.jasig.cas.authentication.AuthenticationMetaDataPopulator;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.RememberMeCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="rememberMeAuthenticationMetaDataPopulator")
public final class RememberMeAuthenticationMetaDataPopulator
implements AuthenticationMetaDataPopulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RememberMeAuthenticationMetaDataPopulator.class);

    public void populateAttributes(AuthenticationBuilder builder, Credential credential) {
        RememberMeCredential r = (RememberMeCredential)credential;
        if (r.isRememberMe()) {
            LOGGER.debug("Credential is configured to be remembered. Captured this as {} attribute", (Object)"org.jasig.cas.authentication.principal.REMEMBER_ME");
            builder.addAttribute("org.jasig.cas.authentication.principal.REMEMBER_ME", (Object)Boolean.TRUE);
        }
    }

    public boolean supports(Credential credential) {
        return credential instanceof RememberMeCredential;
    }
}

