/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CachingPrincipalAttributesRepository
extends AbstractPrincipalAttributesRepository {
    private static final long serialVersionUID = 6350244643948535906L;
    private static final long DEFAULT_MAXIMUM_CACHE_SIZE = 1000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingPrincipalAttributesRepository.class);
    private final transient Cache<String, Map<String, Object>> cache;
    private final transient PrincipalAttributesCacheLoader cacheLoader = new PrincipalAttributesCacheLoader();
    private long maxCacheSize = 1000L;

    private CachingPrincipalAttributesRepository() {
        this.cache = CacheBuilder.newBuilder().maximumSize(this.maxCacheSize).expireAfterWrite(this.expiration, this.timeUnit).build((CacheLoader)this.cacheLoader);
    }

    public CachingPrincipalAttributesRepository(TimeUnit timeUnit, long expiryDuration) {
        this(1000L, timeUnit, expiryDuration);
    }

    public CachingPrincipalAttributesRepository(long maxCacheSize, TimeUnit timeUnit, long expiryDuration) {
        super(expiryDuration, timeUnit);
        this.maxCacheSize = maxCacheSize;
        this.cache = CacheBuilder.newBuilder().maximumSize(maxCacheSize).expireAfterWrite(expiryDuration, timeUnit).build((CacheLoader)this.cacheLoader);
    }

    @Override
    protected void addPrincipalAttributes(String id, Map<String, Object> attributes) {
        this.cache.put((Object)id, attributes);
        LOGGER.debug("Cached attributes for {}", (Object)id);
    }

    @Override
    protected Map<String, Object> getPrincipalAttributes(final Principal p) {
        try {
            return (Map)this.cache.get((Object)p.getId(), (Callable)new Callable<Map<String, Object>>(){

                @Override
                public Map<String, Object> call() throws Exception {
                    LOGGER.debug("No cached attributes could be found for {}", (Object)p.getId());
                    return new HashMap<String, Object>();
                }
            });
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        this.cache.cleanUp();
    }

    private static class PrincipalAttributesCacheLoader
    extends CacheLoader<String, Map<String, Object>> {
        private PrincipalAttributesCacheLoader() {
        }

        public Map<String, Object> load(String key) throws Exception {
            return new HashMap<String, Object>();
        }
    }
}

