/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jasig.cas.authentication.principal.DefaultPrincipalAttributesRepository;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalAttributesRepository;
import org.jasig.cas.services.RegisteredServiceAttributeFilter;
import org.jasig.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRegisteredServiceAttributeReleasePolicy
implements RegisteredServiceAttributeReleasePolicy {
    private static final long serialVersionUID = 5325460875620586503L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRegisteredServiceAttributeReleasePolicy.class);
    private RegisteredServiceAttributeFilter registeredServiceAttributeFilter;
    private PrincipalAttributesRepository principalAttributesRepository = new DefaultPrincipalAttributesRepository();
    private boolean authorizedToReleaseCredentialPassword;
    private boolean authorizedToReleaseProxyGrantingTicket;

    public final void setAttributeFilter(RegisteredServiceAttributeFilter filter) {
        this.registeredServiceAttributeFilter = filter;
    }

    public final void setPrincipalAttributesRepository(PrincipalAttributesRepository repository) {
        this.principalAttributesRepository = repository;
    }

    public PrincipalAttributesRepository getPrincipalAttributesRepository() {
        return this.principalAttributesRepository;
    }

    public final RegisteredServiceAttributeFilter getAttributeFilter() {
        return this.registeredServiceAttributeFilter;
    }

    public boolean isAuthorizedToReleaseCredentialPassword() {
        return this.authorizedToReleaseCredentialPassword;
    }

    public boolean isAuthorizedToReleaseProxyGrantingTicket() {
        return this.authorizedToReleaseProxyGrantingTicket;
    }

    public void setAuthorizedToReleaseCredentialPassword(boolean authorizedToReleaseCredentialPassword) {
        this.authorizedToReleaseCredentialPassword = authorizedToReleaseCredentialPassword;
    }

    public void setAuthorizedToReleaseProxyGrantingTicket(boolean authorizedToReleaseProxyGrantingTicket) {
        this.authorizedToReleaseProxyGrantingTicket = authorizedToReleaseProxyGrantingTicket;
    }

    public final Map<String, Object> getAttributes(Principal p) {
        Map principalAttributes = this.principalAttributesRepository == null ? p.getAttributes() : this.principalAttributesRepository.getAttributes(p);
        Map<String, Object> attributesToRelease = this.getAttributesInternal(principalAttributes);
        if (this.registeredServiceAttributeFilter != null) {
            return this.registeredServiceAttributeFilter.filter(attributesToRelease);
        }
        return attributesToRelease;
    }

    protected abstract Map<String, Object> getAttributesInternal(Map<String, Object> var1);

    public int hashCode() {
        return new HashCodeBuilder(13, 133).append((Object)this.registeredServiceAttributeFilter).append(this.authorizedToReleaseCredentialPassword).append(this.authorizedToReleaseProxyGrantingTicket).append((Object)this.principalAttributesRepository).toHashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractRegisteredServiceAttributeReleasePolicy)) {
            return false;
        }
        AbstractRegisteredServiceAttributeReleasePolicy that = (AbstractRegisteredServiceAttributeReleasePolicy)o;
        EqualsBuilder builder = new EqualsBuilder();
        return builder.append((Object)this.registeredServiceAttributeFilter, (Object)that.registeredServiceAttributeFilter).append(this.authorizedToReleaseCredentialPassword, that.authorizedToReleaseCredentialPassword).append(this.authorizedToReleaseProxyGrantingTicket, that.authorizedToReleaseProxyGrantingTicket).append((Object)this.principalAttributesRepository, (Object)that.principalAttributesRepository).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("attributeFilter", (Object)this.registeredServiceAttributeFilter).append("principalAttributesRepository", (Object)this.principalAttributesRepository).append("authorizedToReleaseCredentialPassword", this.authorizedToReleaseCredentialPassword).append("authorizedToReleaseProxyGrantingTicket", this.authorizedToReleaseProxyGrantingTicket).toString();
    }
}

