/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jasig.cas.services.AbstractRegisteredServiceAttributeReleasePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReturnMappedAttributeReleasePolicy
extends AbstractRegisteredServiceAttributeReleasePolicy {
    private static final long serialVersionUID = -6249488544306639050L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReturnMappedAttributeReleasePolicy.class);
    private Map<String, String> allowedAttributes;

    public ReturnMappedAttributeReleasePolicy() {
        this(new TreeMap<String, String>());
    }

    public ReturnMappedAttributeReleasePolicy(Map<String, String> allowedAttributes) {
        this.allowedAttributes = allowedAttributes;
    }

    public void setAllowedAttributes(Map<String, String> allowed) {
        this.allowedAttributes = allowed;
    }

    public Map<String, String> getAllowedAttributes() {
        return new TreeMap<String, String>(this.allowedAttributes);
    }

    @Override
    protected Map<String, Object> getAttributesInternal(Map<String, Object> resolvedAttributes) {
        HashMap<String, Object> attributesToRelease = new HashMap<String, Object>(resolvedAttributes.size());
        for (Map.Entry<String, String> entry : this.allowedAttributes.entrySet()) {
            String key = entry.getKey();
            Object value = resolvedAttributes.get(key);
            if (value == null) continue;
            String mappedAttributeName = entry.getValue();
            LOGGER.debug("Found attribute [{}] in the list of allowed attributes, mapped to the name [{}]", (Object)key, (Object)mappedAttributeName);
            attributesToRelease.put(mappedAttributeName, value);
        }
        return attributesToRelease;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ReturnMappedAttributeReleasePolicy rhs = (ReturnMappedAttributeReleasePolicy)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.allowedAttributes, rhs.allowedAttributes).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.allowedAttributes).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("allowedAttributes", this.allowedAttributes).toString();
    }
}

