/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.principal.PersistentIdGenerator;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator$AjcClosure1;
import org.jasig.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator$AjcClosure3;
import org.jasig.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator$AjcClosure5;
import org.jasig.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator$AjcClosure7;
import org.jasig.cas.util.CompressionUtils;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="shibbolethCompatiblePersistentIdGenerator")
public final class ShibbolethCompatiblePersistentIdGenerator
implements PersistentIdGenerator {
    private static final long serialVersionUID = 6182838799563190289L;
    private static final Logger LOGGER;
    private static final byte CONST_SEPARATOR = 33;
    private static final int CONST_DEFAULT_SALT_COUNT = 16;
    @JsonProperty
    private final String salt;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        ShibbolethCompatiblePersistentIdGenerator.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(ShibbolethCompatiblePersistentIdGenerator.class);
    }

    public ShibbolethCompatiblePersistentIdGenerator() {
        this.salt = RandomStringUtils.randomAlphanumeric((int)16);
    }

    @Autowired
    public ShibbolethCompatiblePersistentIdGenerator(@NotNull @Value(value="${shib.id.gen.salt:casrox}") String salt) {
        this.salt = salt;
    }

    private byte[] convertSaltToByteArray() {
        return this.salt.getBytes(Charset.defaultCharset());
    }

    @JsonIgnore
    public byte[] getSalt() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (byte[])TraceLogAspect.aspectOf().traceMethod(new ShibbolethCompatiblePersistentIdGenerator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public String generate(Principal principal, Service service) {
        Principal principal2 = principal;
        Service service2 = service;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)principal2, (Object)service2);
        Object[] objectArray = new Object[]{this, principal2, service2, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new ShibbolethCompatiblePersistentIdGenerator$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    public boolean equals(Object obj) {
        Object object = obj;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)object);
        Object[] objectArray = new Object[]{this, object, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new ShibbolethCompatiblePersistentIdGenerator$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public int hashCode() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.intValue((Object)TraceLogAspect.aspectOf().traceMethod(new ShibbolethCompatiblePersistentIdGenerator$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648)));
    }

    static final /* synthetic */ byte[] getSalt_aroundBody0(ShibbolethCompatiblePersistentIdGenerator ajc$this, JoinPoint joinPoint) {
        try {
            return ByteSource.wrap((byte[])ajc$this.convertSaltToByteArray()).read();
        }
        catch (IOException iOException) {
            LOGGER.warn("Salt cannot be read because the byte array from source could not be consumed");
            return null;
        }
    }

    static final /* synthetic */ String generate_aroundBody2(ShibbolethCompatiblePersistentIdGenerator ajc$this, Principal principal, Service service, JoinPoint joinPoint) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            Charset charset = Charset.defaultCharset();
            md.update(service.getId().getBytes(charset));
            md.update((byte)33);
            md.update(principal.getId().getBytes(charset));
            md.update((byte)33);
            String result = CompressionUtils.encodeBase64((byte[])md.digest(ajc$this.convertSaltToByteArray()));
            return result.replaceAll(System.getProperty("line.separator"), "");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static final /* synthetic */ boolean equals_aroundBody4(ShibbolethCompatiblePersistentIdGenerator ajc$this, Object obj, JoinPoint joinPoint) {
        if (obj == null) {
            return false;
        }
        if (obj == ajc$this) {
            return true;
        }
        if (obj.getClass() != ajc$this.getClass()) {
            return false;
        }
        ShibbolethCompatiblePersistentIdGenerator rhs = (ShibbolethCompatiblePersistentIdGenerator)obj;
        return new EqualsBuilder().append((Object)ajc$this.salt, (Object)rhs.salt).isEquals();
    }

    static final /* synthetic */ int hashCode_aroundBody6(ShibbolethCompatiblePersistentIdGenerator ajc$this, JoinPoint joinPoint) {
        return new HashCodeBuilder().append((Object)ajc$this.salt).toHashCode();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ShibbolethCompatiblePersistentIdGenerator.java", ShibbolethCompatiblePersistentIdGenerator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSalt", "org.jasig.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator", "", "", "", "[B"), 73);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generate", "org.jasig.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator", "org.jasig.cas.authentication.principal.Principal:org.jasig.cas.authentication.principal.Service", "principal:service", "", "java.lang.String"), 83);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "equals", "org.jasig.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator", "java.lang.Object", "obj", "", "boolean"), 101);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hashCode", "org.jasig.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator", "", "", "", "int"), 118);
    }
}

