/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.support;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.support.AbstractCasAttributeEncoder;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceCipherExecutor;
import org.jasig.cas.services.ServicesManager;
import org.springframework.stereotype.Component;

@Component(value="casAttributeEncoder")
public class DefaultCasAttributeEncoder
extends AbstractCasAttributeEncoder {
    protected DefaultCasAttributeEncoder() {
    }

    public DefaultCasAttributeEncoder(ServicesManager servicesManager) {
        super(servicesManager);
    }

    public DefaultCasAttributeEncoder(ServicesManager servicesManager, RegisteredServiceCipherExecutor cipherExecutor) {
        super(servicesManager, cipherExecutor);
    }

    protected final void encodeAndEncryptCredentialPassword(Map<String, Object> attributes, Map<String, String> cachedAttributesToEncode, RegisteredServiceCipherExecutor cipher, RegisteredService registeredService) {
        this.encryptAndEncodeAndPutIntoAttributesMap(attributes, cachedAttributesToEncode, "credential", cipher, registeredService);
    }

    protected final void encodeAndEncryptProxyGrantingTicket(Map<String, Object> attributes, Map<String, String> cachedAttributesToEncode, RegisteredServiceCipherExecutor cipher, RegisteredService registeredService) {
        this.encryptAndEncodeAndPutIntoAttributesMap(attributes, cachedAttributesToEncode, "proxyGrantingTicket", cipher, registeredService);
    }

    protected final void encryptAndEncodeAndPutIntoAttributesMap(Map<String, Object> attributes, Map<String, String> cachedAttributesToEncode, String cachedAttributeName, RegisteredServiceCipherExecutor cipher, RegisteredService registeredService) {
        String cachedAttribute = cachedAttributesToEncode.remove(cachedAttributeName);
        if (StringUtils.isNotBlank((CharSequence)cachedAttribute)) {
            this.logger.debug("Retrieved [{}] as a cached model attribute...", (Object)cachedAttributeName);
            String encodedValue = cipher.encode(cachedAttribute, registeredService);
            if (StringUtils.isNotBlank((CharSequence)encodedValue)) {
                attributes.put(cachedAttributeName, encodedValue);
                this.logger.debug("Encrypted and encoded [{}] as an attribute to [{}].", (Object)cachedAttributeName, (Object)encodedValue);
            }
        } else {
            this.logger.debug("[{}] is not available as a cached model attribute to encrypt...", (Object)cachedAttributeName);
        }
    }

    @Override
    protected void encodeAttributesInternal(Map<String, Object> attributes, Map<String, String> cachedAttributesToEncode, RegisteredServiceCipherExecutor cipher, RegisteredService registeredService) {
        this.encodeAndEncryptCredentialPassword(attributes, cachedAttributesToEncode, cipher, registeredService);
        this.encodeAndEncryptProxyGrantingTicket(attributes, cachedAttributesToEncode, cipher, registeredService);
    }
}

