/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.services.DefaultServicesManagerImpl$AjcClosure1;
import org.jasig.cas.services.DefaultServicesManagerImpl$AjcClosure11;
import org.jasig.cas.services.DefaultServicesManagerImpl$AjcClosure13;
import org.jasig.cas.services.DefaultServicesManagerImpl$AjcClosure15;
import org.jasig.cas.services.DefaultServicesManagerImpl$AjcClosure17;
import org.jasig.cas.services.DefaultServicesManagerImpl$AjcClosure19;
import org.jasig.cas.services.DefaultServicesManagerImpl$AjcClosure3;
import org.jasig.cas.services.DefaultServicesManagerImpl$AjcClosure5;
import org.jasig.cas.services.DefaultServicesManagerImpl$AjcClosure7;
import org.jasig.cas.services.DefaultServicesManagerImpl$AjcClosure9;
import org.jasig.cas.services.DefaultServicesManagerImpl$ServiceRegistryReloaderJob$AjcClosure1;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ReloadableServicesManager;
import org.jasig.cas.services.ServiceRegistryDao;
import org.jasig.cas.support.events.CasRegisteredServiceDeletedEvent;
import org.jasig.cas.support.events.CasRegisteredServiceSavedEvent;
import org.jasig.cas.util.CasSpringBeanJobFactory;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.jasig.inspektr.audit.annotation.Audit;
import org.joda.time.DateTime;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.stereotype.Component;

@Component(value="servicesManager")
public final class DefaultServicesManagerImpl
implements ReloadableServicesManager,
ApplicationEventPublisherAware {
    private static final Logger LOGGER;
    @NotNull
    @Autowired
    @Qualifier(value="serviceRegistryDao")
    private ServiceRegistryDao serviceRegistryDao;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    private ConcurrentHashMap<Long, RegisteredService> services = new ConcurrentHashMap();
    @Value(value="${service.registry.quartz.reloader.repeatInterval:60}")
    private int refreshInterval;
    @Value(value="${service.registry.quartz.reloader.startDelay:15}")
    private int startDelay;
    @Autowired
    private ApplicationContext applicationContext;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        DefaultServicesManagerImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(DefaultServicesManagerImpl.class);
    }

    public DefaultServicesManagerImpl() {
    }

    @Autowired
    public DefaultServicesManagerImpl(@Qualifier(value="serviceRegistryDao") ServiceRegistryDao serviceRegistryDao) {
        this.serviceRegistryDao = serviceRegistryDao;
        this.load();
    }

    @Audit(action="DELETE_SERVICE", actionResolverName="DELETE_SERVICE_ACTION_RESOLVER", resourceResolverName="DELETE_SERVICE_RESOURCE_RESOLVER")
    public synchronized RegisteredService delete(long id) {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        return (RegisteredService)TraceLogAspect.aspectOf().traceMethod(new DefaultServicesManagerImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public RegisteredService findServiceBy(Service service) {
        Service service2 = service;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)service2);
        Object[] objectArray = new Object[]{this, service2, joinPoint};
        return (RegisteredService)TraceLogAspect.aspectOf().traceMethod(new DefaultServicesManagerImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    public RegisteredService findServiceBy(long id) {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        return (RegisteredService)TraceLogAspect.aspectOf().traceMethod(new DefaultServicesManagerImpl$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    public TreeSet<RegisteredService> convertToTreeSet() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (TreeSet)TraceLogAspect.aspectOf().traceMethod(new DefaultServicesManagerImpl$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    public Collection<RegisteredService> getAllServices() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (Collection)TraceLogAspect.aspectOf().traceMethod(new DefaultServicesManagerImpl$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    public boolean matchesExistingService(Service service) {
        Service service2 = service;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)service2);
        Object[] objectArray = new Object[]{this, service2, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new DefaultServicesManagerImpl$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @Audit(action="SAVE_SERVICE", actionResolverName="SAVE_SERVICE_ACTION_RESOLVER", resourceResolverName="SAVE_SERVICE_RESOURCE_RESOLVER")
    public synchronized RegisteredService save(RegisteredService registeredService) {
        RegisteredService registeredService2 = registeredService;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)registeredService2);
        Object[] objectArray = new Object[]{this, registeredService2, joinPoint};
        return (RegisteredService)TraceLogAspect.aspectOf().traceMethod(new DefaultServicesManagerImpl$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void reload() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new DefaultServicesManagerImpl$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void load() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new DefaultServicesManagerImpl$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
    }

    @PostConstruct
    public void scheduleReloaderJob() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new DefaultServicesManagerImpl$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648));
    }

    private boolean shouldScheduleLoaderJob() {
        if (this.startDelay > 0 && this.applicationContext.getParent() == null) {
            LOGGER.debug("Found CAS servlet application context for service management");
            return true;
        }
        return false;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    static final /* synthetic */ RegisteredService delete_aroundBody0(DefaultServicesManagerImpl ajc$this, long id, JoinPoint joinPoint) {
        RegisteredService r = ajc$this.findServiceBy(id);
        if (r == null) {
            return null;
        }
        ajc$this.serviceRegistryDao.delete(r);
        ajc$this.services.remove(id);
        ajc$this.eventPublisher.publishEvent((ApplicationEvent)new CasRegisteredServiceDeletedEvent((Object)ajc$this, r));
        return r;
    }

    static final /* synthetic */ RegisteredService findServiceBy_aroundBody2(DefaultServicesManagerImpl ajc$this, Service service, JoinPoint joinPoint) {
        TreeSet<RegisteredService> c = ajc$this.convertToTreeSet();
        for (RegisteredService r : c) {
            if (!r.matches(service)) continue;
            return r;
        }
        return null;
    }

    static final /* synthetic */ RegisteredService findServiceBy_aroundBody4(DefaultServicesManagerImpl ajc$this, long id, JoinPoint joinPoint) {
        RegisteredService r = ajc$this.services.get(id);
        try {
            return r == null ? null : r.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return r;
        }
    }

    static final /* synthetic */ TreeSet convertToTreeSet_aroundBody6(DefaultServicesManagerImpl ajc$this, JoinPoint joinPoint) {
        return new TreeSet<RegisteredService>(ajc$this.services.values());
    }

    static final /* synthetic */ Collection getAllServices_aroundBody8(DefaultServicesManagerImpl ajc$this, JoinPoint joinPoint) {
        return Collections.unmodifiableCollection(ajc$this.convertToTreeSet());
    }

    static final /* synthetic */ boolean matchesExistingService_aroundBody10(DefaultServicesManagerImpl ajc$this, Service service, JoinPoint joinPoint) {
        return ajc$this.findServiceBy(service) != null;
    }

    static final /* synthetic */ RegisteredService save_aroundBody12(DefaultServicesManagerImpl ajc$this, RegisteredService registeredService, JoinPoint joinPoint) {
        RegisteredService r = ajc$this.serviceRegistryDao.save(registeredService);
        ajc$this.services.put(r.getId(), r);
        ajc$this.eventPublisher.publishEvent((ApplicationEvent)new CasRegisteredServiceSavedEvent((Object)ajc$this, r));
        return r;
    }

    static final /* synthetic */ void reload_aroundBody14(DefaultServicesManagerImpl ajc$this, JoinPoint joinPoint) {
        LOGGER.info("Reloading registered services.");
        ajc$this.load();
    }

    static final /* synthetic */ void load_aroundBody16(DefaultServicesManagerImpl ajc$this, JoinPoint joinPoint) {
        ConcurrentHashMap<Long, RegisteredService> localServices = new ConcurrentHashMap<Long, RegisteredService>();
        for (RegisteredService r : ajc$this.serviceRegistryDao.load()) {
            LOGGER.debug("Adding registered service {}", (Object)r.getServiceId());
            localServices.put(r.getId(), r);
        }
        ajc$this.services = localServices;
        LOGGER.info("Loaded {} services from {}.", (Object)ajc$this.services.size(), (Object)ajc$this.serviceRegistryDao);
    }

    static final /* synthetic */ void scheduleReloaderJob_aroundBody18(DefaultServicesManagerImpl ajc$this, JoinPoint joinPoint) {
        try {
            if (ajc$this.shouldScheduleLoaderJob()) {
                LOGGER.debug("Preparing to schedule reloader job");
                JobDetail job = JobBuilder.newJob(ServiceRegistryReloaderJob.class).withIdentity(ajc$this.getClass().getSimpleName().concat(UUID.randomUUID().toString())).build();
                Trigger trigger = TriggerBuilder.newTrigger().withIdentity(ajc$this.getClass().getSimpleName().concat(UUID.randomUUID().toString())).startAt(DateTime.now().plusSeconds(ajc$this.startDelay).toDate()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(ajc$this.refreshInterval).repeatForever()).build();
                CasSpringBeanJobFactory jobFactory = new CasSpringBeanJobFactory(ajc$this.applicationContext);
                StdSchedulerFactory schFactory = new StdSchedulerFactory();
                Scheduler sch = schFactory.getScheduler();
                sch.setJobFactory((JobFactory)jobFactory);
                sch.start();
                LOGGER.debug("Started {} scheduler", (Object)ajc$this.getClass().getName());
                sch.scheduleJob(job, trigger);
                LOGGER.info("Services manager will reload service definitions every {} seconds", (Object)ajc$this.refreshInterval);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DefaultServicesManagerImpl.java", DefaultServicesManagerImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "delete", "org.jasig.cas.services.DefaultServicesManagerImpl", "long", "id", "", "org.jasig.cas.services.RegisteredService"), 100);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findServiceBy", "org.jasig.cas.services.DefaultServicesManagerImpl", "org.jasig.cas.authentication.principal.Service", "service", "", "org.jasig.cas.services.RegisteredService"), 115);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findServiceBy", "org.jasig.cas.services.DefaultServicesManagerImpl", "long", "id", "", "org.jasig.cas.services.RegisteredService"), 128);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "convertToTreeSet", "org.jasig.cas.services.DefaultServicesManagerImpl", "", "", "", "java.util.TreeSet"), 143);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllServices", "org.jasig.cas.services.DefaultServicesManagerImpl", "", "", "", "java.util.Collection"), 148);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "matchesExistingService", "org.jasig.cas.services.DefaultServicesManagerImpl", "org.jasig.cas.authentication.principal.Service", "service", "", "boolean"), 153);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "save", "org.jasig.cas.services.DefaultServicesManagerImpl", "org.jasig.cas.services.RegisteredService", "registeredService", "", "org.jasig.cas.services.RegisteredService"), 160);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "reload", "org.jasig.cas.services.DefaultServicesManagerImpl", "", "", "", "void"), 168);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "load", "org.jasig.cas.services.DefaultServicesManagerImpl", "", "", "", "void"), 176);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "scheduleReloaderJob", "org.jasig.cas.services.DefaultServicesManagerImpl", "", "", "", "void"), 195);
    }

    public static class ServiceRegistryReloaderJob
    implements Job {
        @Autowired
        @Qualifier(value="servicesManager")
        private ReloadableServicesManager servicesManager;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
            JobExecutionContext jobExecutionContext2 = jobExecutionContext;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)jobExecutionContext2);
            Object[] objectArray = new Object[]{this, jobExecutionContext2, joinPoint};
            TraceLogAspect.aspectOf().traceMethod(new DefaultServicesManagerImpl$ServiceRegistryReloaderJob$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }

        static {
            ServiceRegistryReloaderJob.ajc$preClinit();
        }

        static final /* synthetic */ void execute_aroundBody0(ServiceRegistryReloaderJob ajc$this, JobExecutionContext jobExecutionContext, JoinPoint joinPoint) {
            try {
                ajc$this.servicesManager.reload();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("DefaultServicesManagerImpl.java", ServiceRegistryReloaderJob.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "org.jasig.cas.services.DefaultServicesManagerImpl$ServiceRegistryReloaderJob", "org.quartz.JobExecutionContext", "jobExecutionContext", "org.quartz.JobExecutionException", "void"), 252);
        }
    }
}

