/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.services.JsonServiceRegistryConfigWatcher$AjcClosure1;
import org.jasig.cas.services.JsonServiceRegistryDao;
import org.jasig.cas.services.RegisteredService;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JsonServiceRegistryConfigWatcher
implements Runnable {
    private static final Logger LOGGER;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final WatchService watcher;
    private final JsonServiceRegistryDao serviceRegistryDao;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        JsonServiceRegistryConfigWatcher.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(JsonServiceRegistryConfigWatcher.class);
    }

    JsonServiceRegistryConfigWatcher(JsonServiceRegistryDao serviceRegistryDao) {
        try {
            this.serviceRegistryDao = serviceRegistryDao;
            this.watcher = FileSystems.getDefault().newWatchService();
            Object[] kinds = (WatchEvent.Kind[])Arrays.asList(StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY).toArray();
            LOGGER.debug("Created service registry watcher for events of type {}", kinds);
            this.serviceRegistryDao.getServiceRegistryDirectory().register(this.watcher, (WatchEvent.Kind<?>[])kinds);
            LOGGER.debug("Watching service registry directory at {}", (Object)this.serviceRegistryDao.getServiceRegistryDirectory());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new JsonServiceRegistryConfigWatcher$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    private void handleEvent(WatchKey key) {
        this.readLock.lock();
        try {
            for (WatchEvent<?> event : key.pollEvents()) {
                if (event.count() > 1) continue;
                WatchEvent.Kind<?> kind = event.kind();
                WatchEvent<?> ev = event;
                Path filename = (Path)ev.context();
                Path parent = (Path)key.watchable();
                Path fullPath = parent.resolve(filename);
                File file = fullPath.toFile();
                LOGGER.trace("Detected event [{}] on file [{}]. Loading change...", kind, (Object)file);
                if (kind.name().equals(StandardWatchEventKinds.ENTRY_CREATE.name()) && file.exists()) {
                    this.handleCreateEvent(file);
                    continue;
                }
                if (kind.name().equals(StandardWatchEventKinds.ENTRY_DELETE.name())) {
                    this.handleDeleteEvent();
                    continue;
                }
                if (!kind.name().equals(StandardWatchEventKinds.ENTRY_MODIFY.name()) || !file.exists()) continue;
                this.handleModifyEvent(file);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void handleModifyEvent(File file) {
        RegisteredService newService = this.serviceRegistryDao.loadRegisteredServiceFromFile(file);
        if (newService == null) {
            LOGGER.warn("New service definition could not be loaded from [{}]", (Object)file.getAbsolutePath());
        } else {
            RegisteredService oldService = this.serviceRegistryDao.findServiceById(newService.getId());
            if (!newService.equals(oldService)) {
                this.serviceRegistryDao.updateRegisteredService(newService);
                this.serviceRegistryDao.refreshServicesManager();
            } else {
                LOGGER.debug("Service [{}] loaded from [{}] is identical to the existing entry. Services manager will not reload", (Object)newService.getId(), (Object)file.getName());
            }
        }
    }

    private void handleDeleteEvent() {
        this.serviceRegistryDao.load();
        this.serviceRegistryDao.refreshServicesManager();
    }

    private void handleCreateEvent(File file) {
        RegisteredService service = this.serviceRegistryDao.loadRegisteredServiceFromFile(file);
        if (service == null) {
            LOGGER.warn("No service definition was loaded from [{}]", (Object)file);
            return;
        }
        if (this.serviceRegistryDao.findServiceById(service.getId()) != null) {
            LOGGER.warn("Found a service definition [{}] with a duplicate id [{}] in [{}]. This will overwrite previous service definitions and is likely a configuration problem. Make sure all services have a unique id and try again.", new Object[]{service.getServiceId(), service.getId(), file.getAbsolutePath()});
        }
        this.serviceRegistryDao.updateRegisteredService(service);
        this.serviceRegistryDao.refreshServicesManager();
    }

    static final /* synthetic */ void run_aroundBody0(JsonServiceRegistryConfigWatcher ajc$this, JoinPoint joinPoint) {
        if (ajc$this.running.compareAndSet(false, true)) {
            while (ajc$this.running.get()) {
                boolean valid;
                WatchKey key = null;
                try {
                    try {
                        key = ajc$this.watcher.take();
                        ajc$this.handleEvent(key);
                    }
                    catch (InterruptedException interruptedException) {
                        boolean bl = valid = key != null && key.reset();
                        if (!valid) {
                            LOGGER.warn("Directory key is no longer valid. Quitting watcher service");
                            break;
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    boolean bl = valid = key != null && key.reset();
                    if (!valid) {
                        LOGGER.warn("Directory key is no longer valid. Quitting watcher service");
                        break;
                    }
                    throw throwable;
                }
                boolean bl = valid = key != null && key.reset();
                if (valid) continue;
                LOGGER.warn("Directory key is no longer valid. Quitting watcher service");
                break;
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JsonServiceRegistryConfigWatcher.java", JsonServiceRegistryConfigWatcher.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.jasig.cas.services.JsonServiceRegistryConfigWatcher", "", "", "", "void"), 59);
    }
}

