/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import java.util.List;
import javax.annotation.PostConstruct;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServiceRegistryDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="serviceRegistryInitializer")
class ServiceRegistryInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRegistryInitializer.class);
    private final ServiceRegistryDao serviceRegistryDao;
    private final ServiceRegistryDao jsonServiceRegistryDao;
    @Value(value="${svcreg.database.from.json:false}")
    private boolean initFromJsonIfAvailable;

    @Autowired
    ServiceRegistryInitializer(@Qualifier(value="jsonServiceRegistryDao") ServiceRegistryDao jsonServiceRegistryDao, @Qualifier(value="serviceRegistryDao") ServiceRegistryDao serviceRegistryDao) {
        this.jsonServiceRegistryDao = jsonServiceRegistryDao;
        this.serviceRegistryDao = serviceRegistryDao;
    }

    @PostConstruct
    public void initServiceRegistryIfNecessary() {
        if (this.serviceRegistryDao.equals(this.jsonServiceRegistryDao)) {
            return;
        }
        if (this.initFromJsonIfAvailable) {
            long size = this.serviceRegistryDao.load().size();
            if (size == 0L) {
                LOGGER.debug("Service registry database will be auto-initialized from default JSON services");
                List services = this.jsonServiceRegistryDao.load();
                for (RegisteredService r : services) {
                    LOGGER.debug("Initializing DB with the {} JSON service definition...", (Object)r);
                    this.serviceRegistryDao.save(r);
                }
                this.serviceRegistryDao.load();
                LOGGER.info("The service registry database is  initialized from default JSON services.");
            } else {
                LOGGER.debug("Service registry database contains {} service definitions", (Object)size);
            }
        } else {
            LOGGER.info("The service registry database will not be initialized from default JSON services. If the service registry database is empty, CAS will refuse to authenticate services until service definitions are added to the database.");
        }
    }
}

