/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.ServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceFactory<T extends Service>
implements ServiceFactory<T> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public <T1 extends Service> T1 createService(String id, Class<? extends Service> clazz) {
        Service service = this.createService(id);
        if (!clazz.isAssignableFrom(service.getClass())) {
            throw new ClassCastException("Service [" + service.getId() + " is of type " + service.getClass() + " when we were expecting " + clazz);
        }
        return (T1)service;
    }

    public <T1 extends Service> T1 createService(HttpServletRequest request, Class<? extends Service> clazz) {
        Service service = this.createService(request);
        if (!clazz.isAssignableFrom(service.getClass())) {
            throw new ClassCastException("Service [" + service.getId() + " is of type " + service.getClass() + " when we were expecting " + clazz);
        }
        return (T1)service;
    }

    protected static String cleanupUrl(String url) {
        if (url == null) {
            return null;
        }
        int jsessionPosition = url.indexOf(";jsession");
        if (jsessionPosition == -1) {
            return url;
        }
        int questionMarkPosition = url.indexOf(63);
        if (questionMarkPosition < jsessionPosition) {
            return url.substring(0, url.indexOf(";jsession"));
        }
        return String.valueOf(url.substring(0, jsessionPosition)) + url.substring(questionMarkPosition);
    }
}

