/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Response;
import org.jasig.cas.authentication.principal.ResponseBuilder;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.logout.SingleLogoutService;
import org.jasig.cas.validation.ValidationResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebApplicationService
implements SingleLogoutService {
    private static final long serialVersionUID = 610105280927740076L;
    private static final Map<String, Object> EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String id;
    private final String originalUrl;
    private final String artifactId;
    private Principal principal;
    private boolean loggedOutAlready;
    private final ResponseBuilder<WebApplicationService> responseBuilder;
    private ValidationResponseType format = ValidationResponseType.XML;

    protected AbstractWebApplicationService(String id, String originalUrl, String artifactId, ResponseBuilder<WebApplicationService> responseBuilder) {
        this.id = id;
        this.originalUrl = originalUrl;
        this.artifactId = artifactId;
        this.responseBuilder = responseBuilder;
    }

    public final String toString() {
        return this.id;
    }

    public final String getId() {
        return this.id;
    }

    public final String getArtifactId() {
        return this.artifactId;
    }

    public final Map<String, Object> getAttributes() {
        return EMPTY_MAP;
    }

    public final String getOriginalUrl() {
        return this.originalUrl;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Service) {
            Service service = (Service)object;
            return this.getId().equals(service.getId());
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).toHashCode();
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public boolean matches(Service service) {
        try {
            String thisUrl = URLDecoder.decode(this.id, "UTF-8");
            String serviceUrl = URLDecoder.decode(service.getId(), "UTF-8");
            this.logger.trace("Decoded urls and comparing [{}] with [{}]", (Object)thisUrl, (Object)serviceUrl);
            return thisUrl.equalsIgnoreCase(serviceUrl);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean isLoggedOutAlready() {
        return this.loggedOutAlready;
    }

    public final void setLoggedOutAlready(boolean loggedOutAlready) {
        this.loggedOutAlready = loggedOutAlready;
    }

    protected ResponseBuilder<? extends WebApplicationService> getResponseBuilder() {
        return this.responseBuilder;
    }

    public ValidationResponseType getFormat() {
        return this.format;
    }

    public void setFormat(ValidationResponseType format) {
        this.format = format;
    }

    public Response getResponse(String ticketId) {
        return this.responseBuilder.build((WebApplicationService)this, ticketId);
    }
}

