/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jasig.cas.authentication.principal.PersistentIdGenerator;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.util.CompressionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="shibbolethCompatiblePersistentIdGenerator")
public final class ShibbolethCompatiblePersistentIdGenerator
implements PersistentIdGenerator {
    private static final long serialVersionUID = 6182838799563190289L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ShibbolethCompatiblePersistentIdGenerator.class);
    private static final byte CONST_SEPARATOR = 33;
    private static final int CONST_DEFAULT_SALT_COUNT = 16;
    @JsonProperty
    private final String salt;

    public ShibbolethCompatiblePersistentIdGenerator() {
        this.salt = RandomStringUtils.randomAlphanumeric((int)16);
    }

    @Autowired
    public ShibbolethCompatiblePersistentIdGenerator(@NotNull @Value(value="${shib.id.gen.salt:casrox}") String salt) {
        this.salt = salt;
    }

    private byte[] convertSaltToByteArray() {
        return this.salt.getBytes(Charset.defaultCharset());
    }

    @JsonIgnore
    public byte[] getSalt() {
        try {
            return ByteSource.wrap((byte[])this.convertSaltToByteArray()).read();
        }
        catch (IOException iOException) {
            LOGGER.warn("Salt cannot be read because the byte array from source could not be consumed");
            return null;
        }
    }

    public String generate(Principal principal, Service service) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            Charset charset = Charset.defaultCharset();
            md.update(service.getId().getBytes(charset));
            md.update((byte)33);
            md.update(principal.getId().getBytes(charset));
            md.update((byte)33);
            String result = CompressionUtils.encodeBase64((byte[])md.digest(this.convertSaltToByteArray()));
            return result.replaceAll(System.getProperty("line.separator"), "");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ShibbolethCompatiblePersistentIdGenerator rhs = (ShibbolethCompatiblePersistentIdGenerator)obj;
        return new EqualsBuilder().append((Object)this.salt, (Object)rhs.salt).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.salt).toHashCode();
    }
}

