/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.principal.AbstractServiceFactory;
import org.jasig.cas.authentication.principal.Response;
import org.jasig.cas.authentication.principal.SimpleWebApplicationServiceImpl;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.authentication.principal.WebApplicationServiceResponseBuilder;
import org.jasig.cas.validation.ValidationResponseType;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component(value="webApplicationServiceFactory")
public class WebApplicationServiceFactory
extends AbstractServiceFactory<WebApplicationService> {
    public WebApplicationService createService(HttpServletRequest request) {
        String targetService = request.getParameter("targetService");
        String service = request.getParameter("service");
        String serviceAttribute = (String)request.getAttribute("service");
        String method = request.getParameter("method");
        String format = request.getParameter("format");
        String serviceToUse = StringUtils.isNotBlank((CharSequence)targetService) ? targetService : (StringUtils.isNotBlank((CharSequence)service) ? service : serviceAttribute);
        if (StringUtils.isBlank((CharSequence)serviceToUse)) {
            return null;
        }
        String id = AbstractServiceFactory.cleanupUrl(serviceToUse);
        String artifactId = request.getParameter("ticket");
        Response.ResponseType type = HttpMethod.POST.name().equalsIgnoreCase(method) ? Response.ResponseType.POST : Response.ResponseType.REDIRECT;
        SimpleWebApplicationServiceImpl webApplicationService = new SimpleWebApplicationServiceImpl(id, serviceToUse, artifactId, new WebApplicationServiceResponseBuilder(type));
        try {
            if (StringUtils.isNotBlank((CharSequence)format)) {
                ValidationResponseType formatType = ValidationResponseType.valueOf((String)format.toUpperCase());
                webApplicationService.setFormat(formatType);
            }
        }
        catch (Exception exception) {
            this.logger.error("Format specified in the request [{}] is not recognized", (Object)format);
            return null;
        }
        return webApplicationService;
    }

    public WebApplicationService createService(String id) {
        return new SimpleWebApplicationServiceImpl(id, id, null, new WebApplicationServiceResponseBuilder(Response.ResponseType.REDIRECT));
    }
}

