/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jasig.cas.services.RegisteredServiceProperty;

@Entity
@Table(name="RegisteredServiceImplProperty")
public class DefaultRegisteredServiceProperty
implements RegisteredServiceProperty {
    private static final long serialVersionUID = 1349556364689133211L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Lob
    @Column(name="property_values")
    private HashSet<String> values = new HashSet();

    public Set<String> getValues() {
        if (this.values == null) {
            this.values = new HashSet();
        }
        return this.values;
    }

    @JsonIgnore
    public String getValue() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.iterator().next();
    }

    public boolean contains(String value) {
        return this.values.contains(value);
    }

    public void setValues(Set<String> values) {
        this.getValues().clear();
        if (values == null) {
            return;
        }
        for (String handler : values) {
            this.getValues().add(handler);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultRegisteredServiceProperty rhs = (DefaultRegisteredServiceProperty)obj;
        return new EqualsBuilder().append(this.values, rhs.values).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.values).toHashCode();
    }
}

