/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ReloadableServicesManager;
import org.jasig.cas.services.ServiceRegistryDao;
import org.jasig.cas.support.events.CasRegisteredServiceDeletedEvent;
import org.jasig.cas.support.events.CasRegisteredServiceSavedEvent;
import org.jasig.inspektr.audit.annotation.Audit;
import org.joda.time.DateTime;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.stereotype.Component;

@Component(value="servicesManager")
public class DefaultServicesManagerImpl
implements ReloadableServicesManager,
ApplicationEventPublisherAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServicesManagerImpl.class);
    @Autowired
    @Qualifier(value="serviceRegistryDao")
    private ServiceRegistryDao serviceRegistryDao;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    private ConcurrentHashMap<Long, RegisteredService> services = new ConcurrentHashMap();
    @Value(value="${service.registry.quartz.reloader.repeatInterval:60}")
    private int refreshInterval;
    @Value(value="${service.registry.quartz.reloader.startDelay:15}")
    private int startDelay;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    @Qualifier(value="scheduler")
    private Scheduler scheduler;

    public DefaultServicesManagerImpl() {
    }

    @Autowired
    public DefaultServicesManagerImpl(@Qualifier(value="serviceRegistryDao") ServiceRegistryDao serviceRegistryDao) {
        this.serviceRegistryDao = serviceRegistryDao;
        this.load();
    }

    @Audit(action="DELETE_SERVICE", actionResolverName="DELETE_SERVICE_ACTION_RESOLVER", resourceResolverName="DELETE_SERVICE_RESOURCE_RESOLVER")
    public synchronized RegisteredService delete(long id) {
        RegisteredService r = this.findServiceBy(id);
        if (r == null) {
            return null;
        }
        this.serviceRegistryDao.delete(r);
        this.services.remove(id);
        this.eventPublisher.publishEvent((ApplicationEvent)new CasRegisteredServiceDeletedEvent((Object)this, r));
        return r;
    }

    public RegisteredService findServiceBy(Service service) {
        TreeSet<RegisteredService> c = this.convertToTreeSet();
        for (RegisteredService r : c) {
            if (!r.matches(service)) continue;
            return r;
        }
        return null;
    }

    public RegisteredService findServiceBy(long id) {
        RegisteredService r = this.services.get(id);
        try {
            return r == null ? null : r.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return r;
        }
    }

    public TreeSet<RegisteredService> convertToTreeSet() {
        return new TreeSet<RegisteredService>(this.services.values());
    }

    public Collection<RegisteredService> getAllServices() {
        return Collections.unmodifiableCollection(this.convertToTreeSet());
    }

    public boolean matchesExistingService(Service service) {
        return this.findServiceBy(service) != null;
    }

    @Audit(action="SAVE_SERVICE", actionResolverName="SAVE_SERVICE_ACTION_RESOLVER", resourceResolverName="SAVE_SERVICE_RESOURCE_RESOLVER")
    public synchronized RegisteredService save(RegisteredService registeredService) {
        RegisteredService r = this.serviceRegistryDao.save(registeredService);
        this.services.put(r.getId(), r);
        this.eventPublisher.publishEvent((ApplicationEvent)new CasRegisteredServiceSavedEvent((Object)this, r));
        return r;
    }

    public void reload() {
        LOGGER.info("Reloading registered services.");
        this.load();
    }

    public void load() {
        ConcurrentHashMap<Long, RegisteredService> localServices = new ConcurrentHashMap<Long, RegisteredService>();
        for (RegisteredService r : this.serviceRegistryDao.load()) {
            LOGGER.debug("Adding registered service {}", (Object)r.getServiceId());
            localServices.put(r.getId(), r);
        }
        this.services = localServices;
        LOGGER.info("Loaded {} services from {}.", (Object)this.services.size(), (Object)this.serviceRegistryDao);
    }

    @PostConstruct
    public void scheduleReloaderJob() {
        try {
            if (this.shouldScheduleLoaderJob()) {
                LOGGER.debug("Preparing to schedule reloader job");
                JobDetail job = JobBuilder.newJob(ServiceRegistryReloaderJob.class).withIdentity(this.getClass().getSimpleName().concat(UUID.randomUUID().toString())).build();
                Trigger trigger = TriggerBuilder.newTrigger().withIdentity(this.getClass().getSimpleName().concat(UUID.randomUUID().toString())).startAt(DateTime.now().plusSeconds(this.startDelay).toDate()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(this.refreshInterval).repeatForever()).build();
                LOGGER.debug("Scheduling {} job", (Object)this.getClass().getName());
                this.scheduler.scheduleJob(job, trigger);
                LOGGER.info("Services manager will reload service definitions every {} seconds", (Object)this.refreshInterval);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    private boolean shouldScheduleLoaderJob() {
        if (this.startDelay > 0 && this.applicationContext.getParent() == null && this.scheduler != null) {
            LOGGER.debug("Found CAS servlet application context for service management");
            return true;
        }
        return false;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    public static class ServiceRegistryReloaderJob
    implements Job {
        @Autowired
        @Qualifier(value="servicesManager")
        private ReloadableServicesManager servicesManager;

        public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
            try {
                this.servicesManager.reload();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

