/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.jasig.cas.services.AbstractRegisteredService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServiceRegistryDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="inMemoryServiceRegistryDao")
public final class InMemoryServiceRegistryDaoImpl
implements ServiceRegistryDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryServiceRegistryDaoImpl.class);
    @NotNull
    private List<RegisteredService> registeredServices = new ArrayList<RegisteredService>();
    @Autowired
    private ApplicationContext applicationContext;

    @PostConstruct
    public void afterPropertiesSet() {
        String[] aliases = this.applicationContext.getAutowireCapableBeanFactory().getAliases("inMemoryServiceRegistryDao");
        if (aliases.length > 0) {
            LOGGER.debug("{} is used as the active service registry dao", (Object)this.getClass().getSimpleName());
            try {
                List list = (List)this.applicationContext.getBean("inMemoryRegisteredServices", List.class);
                if (list != null) {
                    LOGGER.debug("Loaded {} services from the application context for {}", (Object)list.size(), (Object)this.getClass().getSimpleName());
                    this.registeredServices = list;
                }
            }
            catch (Exception exception) {
                LOGGER.debug("No registered services are defined for {}", (Object)this.getClass().getSimpleName());
            }
        }
    }

    public boolean delete(RegisteredService registeredService) {
        this.logWarning();
        return this.registeredServices.remove(registeredService);
    }

    public RegisteredService findServiceById(long id) {
        for (RegisteredService r : this.registeredServices) {
            if (r.getId() != id) continue;
            return r;
        }
        return null;
    }

    public List<RegisteredService> load() {
        return this.registeredServices;
    }

    public RegisteredService save(RegisteredService registeredService) {
        this.logWarning();
        if (registeredService.getId() == -9223372036854775807L) {
            ((AbstractRegisteredService)registeredService).setId(this.findHighestId() + 1L);
        }
        this.registeredServices.remove(registeredService);
        this.registeredServices.add(registeredService);
        return registeredService;
    }

    public void setRegisteredServices(List registeredServices) {
        this.registeredServices = registeredServices;
    }

    private long findHighestId() {
        long id = 0L;
        for (RegisteredService r : this.registeredServices) {
            if (r.getId() <= id) continue;
            id = r.getId();
        }
        return id;
    }

    private void logWarning() {
        LOGGER.debug("Runtime memory is used as the persistence storage for retrieving and persisting service definitions. Changes that are made to service definitions during runtime will be LOST upon container restarts.");
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

