/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jasig.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeBasedRegisteredServiceAccessStrategy
extends DefaultRegisteredServiceAccessStrategy {
    private static final long serialVersionUID = -6180748828025837047L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeBasedRegisteredServiceAccessStrategy.class);
    private String startingDateTime;
    private String endingDateTime;

    public TimeBasedRegisteredServiceAccessStrategy() {
    }

    public TimeBasedRegisteredServiceAccessStrategy(boolean enabled, boolean ssoEnabled) {
        super(enabled, ssoEnabled);
    }

    public String getStartingDateTime() {
        return this.startingDateTime;
    }

    public String getEndingDateTime() {
        return this.endingDateTime;
    }

    public void setStartingDateTime(String startingDateTime) {
        this.startingDateTime = startingDateTime;
    }

    public void setEndingDateTime(String endingDateTime) {
        this.endingDateTime = endingDateTime;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TimeBasedRegisteredServiceAccessStrategy rhs = (TimeBasedRegisteredServiceAccessStrategy)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.startingDateTime, (Object)rhs.startingDateTime).append((Object)this.endingDateTime, (Object)rhs.endingDateTime).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.startingDateTime).append((Object)this.endingDateTime).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("startingDateTime", (Object)this.startingDateTime).append("endingDateTime", (Object)this.endingDateTime).toString();
    }

    @Override
    public boolean isServiceAccessAllowed() {
        DateTime et;
        DateTime st;
        DateTime now = DateTime.now();
        if (this.startingDateTime != null && now.isBefore((ReadableInstant)(st = DateTime.parse((String)this.startingDateTime)))) {
            LOGGER.warn("Service access not allowed because it starts at {}. Now is {}", (Object)this.startingDateTime, (Object)now);
            return false;
        }
        if (this.endingDateTime != null && now.isAfter((ReadableInstant)(et = DateTime.parse((String)this.endingDateTime)))) {
            LOGGER.warn("Service access not allowed because it ended at {}. Now is {}", (Object)this.endingDateTime, (Object)now);
            return false;
        }
        return super.isServiceAccessAllowed();
    }
}

