/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jasig.cas.services.RegisteredServiceAttributeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegisteredServiceRegexAttributeFilter
implements RegisteredServiceAttributeFilter {
    private static final long serialVersionUID = 403015306984610128L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceRegexAttributeFilter.class);
    @NotNull
    private Pattern pattern;

    protected RegisteredServiceRegexAttributeFilter() {
    }

    public RegisteredServiceRegexAttributeFilter(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Map<String, Object> filter(Map<String, Object> givenAttributes) {
        HashMap<String, Object> attributesToRelease = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : givenAttributes.entrySet()) {
            Object filteredAttributes;
            String attributeName = entry.getKey();
            Object attributeValue = entry.getValue();
            LOGGER.debug("Received attribute [{}] with value [{}]", (Object)attributeName, attributeValue);
            if (attributeValue == null) continue;
            if (attributeValue instanceof Collection) {
                LOGGER.trace("Attribute value {} is a collection", attributeValue);
                filteredAttributes = this.filterArrayAttributes(((Collection)attributeValue).toArray(new String[0]), attributeName);
                if (((String[])filteredAttributes).length <= 0) continue;
                attributesToRelease.put(attributeName, Arrays.asList(filteredAttributes));
                continue;
            }
            if (attributeValue.getClass().isArray()) {
                LOGGER.trace("Attribute value {} is an array", attributeValue);
                filteredAttributes = this.filterArrayAttributes((String[])attributeValue, attributeName);
                if (((String[])filteredAttributes).length <= 0) continue;
                attributesToRelease.put(attributeName, Arrays.asList(filteredAttributes));
                continue;
            }
            if (attributeValue instanceof Map) {
                LOGGER.trace("Attribute value {} is a map", attributeValue);
                filteredAttributes = this.filterMapAttributes((Map)attributeValue);
                if (filteredAttributes.isEmpty()) continue;
                attributesToRelease.put(attributeName, filteredAttributes);
                continue;
            }
            LOGGER.trace("Attribute value {} is a string", attributeValue);
            String attrValue = attributeValue.toString();
            if (!this.patternMatchesAttributeValue(attrValue)) continue;
            this.logReleasedAttributeEntry(attributeName, attrValue);
            attributesToRelease.put(attributeName, attrValue);
        }
        LOGGER.debug("Received {} attributes. Filtered and released {}", (Object)givenAttributes.size(), (Object)attributesToRelease.size());
        return attributesToRelease;
    }

    private Map<String, String> filterMapAttributes(Map<String, String> valuesToFilter) {
        HashMap<String, String> attributesToFilter = new HashMap<String, String>(valuesToFilter.size());
        for (Map.Entry<String, String> entry : valuesToFilter.entrySet()) {
            String attributeName = entry.getKey();
            String attributeValue = entry.getValue();
            if (!this.patternMatchesAttributeValue(attributeValue)) continue;
            this.logReleasedAttributeEntry(attributeName, attributeValue);
            attributesToFilter.put(attributeName, valuesToFilter.get(attributeName));
        }
        return attributesToFilter;
    }

    private boolean patternMatchesAttributeValue(String value) {
        return this.pattern.matcher(value).matches();
    }

    private String[] filterArrayAttributes(String[] valuesToFilter, String attributeName) {
        ArrayList<String> vector = new ArrayList<String>(valuesToFilter.length);
        String[] stringArray = valuesToFilter;
        int n = valuesToFilter.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeValue = stringArray[n2];
            if (this.patternMatchesAttributeValue(attributeValue)) {
                this.logReleasedAttributeEntry(attributeName, attributeValue);
                vector.add(attributeValue);
            }
            ++n2;
        }
        return vector.toArray(new String[0]);
    }

    private void logReleasedAttributeEntry(String attributeName, String attributeValue) {
        LOGGER.debug("The attribute value [{}] for attribute name {} matches the pattern {}. Releasing attribute...", new Object[]{attributeValue, attributeName, this.pattern.pattern()});
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 83).append((Object)this.pattern).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RegisteredServiceRegexAttributeFilter rhs = (RegisteredServiceRegexAttributeFilter)obj;
        return new EqualsBuilder().append((Object)this.pattern.pattern(), (Object)rhs.getPattern().pattern()).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("pattern", (Object)this.pattern.pattern()).toString();
    }
}

