/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket;

import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketFactory;
import org.jasig.cas.ticket.UniqueTicketIdGenerator;
import org.jasig.cas.ticket.proxy.ProxyGrantingTicket;
import org.jasig.cas.ticket.proxy.ProxyGrantingTicketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="defaultProxyGrantingTicketFactory")
public class DefaultProxyGrantingTicketFactory
implements ProxyGrantingTicketFactory {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    @Resource(name="ticketGrantingTicketUniqueIdGenerator")
    protected UniqueTicketIdGenerator ticketGrantingTicketUniqueTicketIdGenerator;
    @NotNull
    @Resource(name="grantingTicketExpirationPolicy")
    protected ExpirationPolicy ticketGrantingTicketExpirationPolicy;

    public <T extends ProxyGrantingTicket> T create(ServiceTicket serviceTicket, Authentication authentication) {
        String pgtId = this.ticketGrantingTicketUniqueTicketIdGenerator.getNewTicketId("PGT");
        ProxyGrantingTicket proxyGrantingTicket = serviceTicket.grantProxyGrantingTicket(pgtId, authentication, this.ticketGrantingTicketExpirationPolicy);
        return (T)proxyGrantingTicket;
    }

    public <T extends TicketFactory> T get(Class<? extends Ticket> clazz) {
        return (T)this;
    }

    public void setTicketGrantingTicketUniqueTicketIdGenerator(UniqueTicketIdGenerator ticketGrantingTicketUniqueTicketIdGenerator) {
        this.ticketGrantingTicketUniqueTicketIdGenerator = ticketGrantingTicketUniqueTicketIdGenerator;
    }

    public void setTicketGrantingTicketExpirationPolicy(ExpirationPolicy ticketGrantingTicketExpirationPolicy) {
        this.ticketGrantingTicketExpirationPolicy = ticketGrantingTicketExpirationPolicy;
    }
}

