/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket;

import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketFactory;
import org.jasig.cas.ticket.UniqueTicketIdGenerator;
import org.jasig.cas.ticket.proxy.ProxyGrantingTicket;
import org.jasig.cas.ticket.proxy.ProxyTicket;
import org.jasig.cas.ticket.proxy.ProxyTicketFactory;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="defaultProxyTicketFactory")
public class DefaultProxyTicketFactory
implements ProxyTicketFactory {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    protected final UniqueTicketIdGenerator defaultServiceTicketIdGenerator = new DefaultUniqueTicketIdGenerator();
    @NotNull
    @Resource(name="uniqueIdGeneratorsMap")
    protected Map<String, UniqueTicketIdGenerator> uniqueTicketIdGeneratorsForService;
    @Value(value="${tgt.onlyTrackMostRecentSession:true}")
    protected boolean onlyTrackMostRecentSession = true;
    @NotNull
    @Resource(name="serviceTicketExpirationPolicy")
    protected ExpirationPolicy serviceTicketExpirationPolicy;

    public <T extends Ticket> T create(ProxyGrantingTicket proxyGrantingTicket, Service service) {
        String uniqueTicketIdGenKey = service.getClass().getName();
        this.logger.debug("Looking up service ticket id generator for [{}]", (Object)uniqueTicketIdGenKey);
        UniqueTicketIdGenerator serviceTicketUniqueTicketIdGenerator = this.uniqueTicketIdGeneratorsForService.get(uniqueTicketIdGenKey);
        if (serviceTicketUniqueTicketIdGenerator == null) {
            serviceTicketUniqueTicketIdGenerator = this.defaultServiceTicketIdGenerator;
            this.logger.debug("Service ticket id generator not found for [{}]. Using the default generator...", (Object)uniqueTicketIdGenKey);
        }
        String ticketId = serviceTicketUniqueTicketIdGenerator.getNewTicketId("PT");
        ProxyTicket serviceTicket = proxyGrantingTicket.grantProxyTicket(ticketId, service, this.serviceTicketExpirationPolicy, this.onlyTrackMostRecentSession);
        return (T)serviceTicket;
    }

    public <T extends TicketFactory> T get(Class<? extends Ticket> clazz) {
        return (T)this;
    }

    public final boolean isOnlyTrackMostRecentSession() {
        return this.onlyTrackMostRecentSession;
    }

    public final void setOnlyTrackMostRecentSession(boolean onlyTrackMostRecentSession) {
        this.onlyTrackMostRecentSession = onlyTrackMostRecentSession;
    }

    public void setUniqueTicketIdGeneratorsForService(Map<String, UniqueTicketIdGenerator> uniqueTicketIdGeneratorsForService) {
        this.uniqueTicketIdGeneratorsForService = uniqueTicketIdGeneratorsForService;
    }

    public void setServiceTicketExpirationPolicy(ExpirationPolicy serviceTicketExpirationPolicy) {
        this.serviceTicketExpirationPolicy = serviceTicketExpirationPolicy;
    }
}

