/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket;

import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.ServiceTicketFactory;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketFactory;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.UniqueTicketIdGenerator;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="defaultServiceTicketFactory")
public class DefaultServiceTicketFactory
implements ServiceTicketFactory {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    protected UniqueTicketIdGenerator defaultServiceTicketIdGenerator = new DefaultUniqueTicketIdGenerator();
    @NotNull
    @Resource(name="uniqueIdGeneratorsMap")
    protected Map<String, UniqueTicketIdGenerator> uniqueTicketIdGeneratorsForService;
    @Value(value="${tgt.onlyTrackMostRecentSession:true}")
    protected boolean onlyTrackMostRecentSession = true;
    @NotNull
    @Resource(name="serviceTicketExpirationPolicy")
    protected ExpirationPolicy serviceTicketExpirationPolicy;

    public <T extends Ticket> T create(TicketGrantingTicket ticketGrantingTicket, Service service, boolean credentialsProvided) {
        String uniqueTicketIdGenKey = service.getClass().getName();
        UniqueTicketIdGenerator serviceTicketUniqueTicketIdGenerator = null;
        if (this.uniqueTicketIdGeneratorsForService != null && !this.uniqueTicketIdGeneratorsForService.isEmpty()) {
            this.logger.debug("Looking up service ticket id generator for [{}]", (Object)uniqueTicketIdGenKey);
            serviceTicketUniqueTicketIdGenerator = this.uniqueTicketIdGeneratorsForService.get(uniqueTicketIdGenKey);
        }
        if (serviceTicketUniqueTicketIdGenerator == null) {
            serviceTicketUniqueTicketIdGenerator = this.defaultServiceTicketIdGenerator;
            this.logger.debug("Service ticket id generator not found for [{}]. Using the default generator...", (Object)uniqueTicketIdGenKey);
        }
        String ticketId = serviceTicketUniqueTicketIdGenerator.getNewTicketId("ST");
        ServiceTicket serviceTicket = ticketGrantingTicket.grantServiceTicket(ticketId, service, this.serviceTicketExpirationPolicy, credentialsProvided, this.onlyTrackMostRecentSession);
        return (T)serviceTicket;
    }

    public <T extends TicketFactory> T get(Class<? extends Ticket> clazz) {
        return (T)this;
    }

    public final boolean isOnlyTrackMostRecentSession() {
        return this.onlyTrackMostRecentSession;
    }

    public final void setOnlyTrackMostRecentSession(boolean onlyTrackMostRecentSession) {
        this.onlyTrackMostRecentSession = onlyTrackMostRecentSession;
    }

    public void setUniqueTicketIdGeneratorsForService(Map<String, UniqueTicketIdGenerator> uniqueTicketIdGeneratorsForService) {
        this.uniqueTicketIdGeneratorsForService = uniqueTicketIdGeneratorsForService;
    }

    public void setServiceTicketExpirationPolicy(ExpirationPolicy serviceTicketExpirationPolicy) {
        this.serviceTicketExpirationPolicy = serviceTicketExpirationPolicy;
    }

    public void setDefaultServiceTicketIdGenerator(UniqueTicketIdGenerator defaultServiceTicketIdGenerator) {
        this.defaultServiceTicketIdGenerator = defaultServiceTicketIdGenerator;
    }
}

