/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.ServiceTicketFactory;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketFactory;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketFactory;
import org.jasig.cas.ticket.proxy.ProxyGrantingTicket;
import org.jasig.cas.ticket.proxy.ProxyGrantingTicketFactory;
import org.jasig.cas.ticket.proxy.ProxyTicket;
import org.jasig.cas.ticket.proxy.ProxyTicketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="defaultTicketFactory")
public class DefaultTicketFactory
implements TicketFactory {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, Object> factoryMap;
    @Autowired
    @Qualifier(value="defaultProxyTicketFactory")
    private ProxyTicketFactory proxyTicketFactory;
    @Autowired
    @Qualifier(value="defaultServiceTicketFactory")
    private ServiceTicketFactory serviceTicketFactory;
    @Autowired
    @Qualifier(value="defaultTicketGrantingTicketFactory")
    private TicketGrantingTicketFactory ticketGrantingTicketFactory;
    @Autowired
    @Qualifier(value="defaultProxyGrantingTicketFactory")
    private ProxyGrantingTicketFactory proxyGrantingTicketFactory;

    @PostConstruct
    public void initialize() {
        this.factoryMap = new HashMap<String, Object>();
        this.validateFactoryInstances();
        this.factoryMap.put(ProxyGrantingTicket.class.getCanonicalName(), this.proxyGrantingTicketFactory);
        this.factoryMap.put(TicketGrantingTicket.class.getCanonicalName(), this.ticketGrantingTicketFactory);
        this.factoryMap.put(ServiceTicket.class.getCanonicalName(), this.serviceTicketFactory);
        this.factoryMap.put(ProxyTicket.class.getCanonicalName(), this.proxyTicketFactory);
    }

    private void validateFactoryInstances() {
        Assert.notNull((Object)this.ticketGrantingTicketFactory, (String)"ticketGrantingTicketFactory cannot be null");
        Assert.notNull((Object)this.proxyGrantingTicketFactory, (String)"proxyGrantingTicketFactory cannot be null");
        Assert.notNull((Object)this.serviceTicketFactory, (String)"serviceTicketFactory cannot be null");
        Assert.notNull((Object)this.proxyTicketFactory, (String)"proxyTicketFactory cannot be null");
    }

    public <T extends TicketFactory> T get(Class<? extends Ticket> clazz) {
        this.validateFactoryInstances();
        return (T)((TicketFactory)this.factoryMap.get(clazz.getCanonicalName()));
    }

    public void setTicketGrantingTicketFactory(TicketGrantingTicketFactory ticketGrantingTicketFactory) {
        this.ticketGrantingTicketFactory = ticketGrantingTicketFactory;
    }

    public void setProxyGrantingTicketFactory(ProxyGrantingTicketFactory proxyGrantingTicketFactory) {
        this.proxyGrantingTicketFactory = proxyGrantingTicketFactory;
    }

    public void setServiceTicketFactory(ServiceTicketFactory serviceTicketFactory) {
        this.serviceTicketFactory = serviceTicketFactory;
    }

    public void setProxyTicketFactory(ProxyTicketFactory proxyTicketFactory) {
        this.proxyTicketFactory = proxyTicketFactory;
    }
}

