/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket;

import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketFactory;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketFactory;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.UniqueTicketIdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="defaultTicketGrantingTicketFactory")
public class DefaultTicketGrantingTicketFactory
implements TicketGrantingTicketFactory {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    @Resource(name="ticketGrantingTicketUniqueIdGenerator")
    protected UniqueTicketIdGenerator ticketGrantingTicketUniqueTicketIdGenerator;
    @NotNull
    @Resource(name="grantingTicketExpirationPolicy")
    protected ExpirationPolicy ticketGrantingTicketExpirationPolicy;

    public <T extends TicketGrantingTicket> T create(Authentication authentication) {
        TicketGrantingTicketImpl ticketGrantingTicket = new TicketGrantingTicketImpl(this.ticketGrantingTicketUniqueTicketIdGenerator.getNewTicketId("TGT"), authentication, this.ticketGrantingTicketExpirationPolicy);
        return (T)ticketGrantingTicket;
    }

    public <T extends TicketFactory> T get(Class<? extends Ticket> clazz) {
        return (T)this;
    }

    public void setTicketGrantingTicketUniqueTicketIdGenerator(UniqueTicketIdGenerator ticketGrantingTicketUniqueTicketIdGenerator) {
        this.ticketGrantingTicketUniqueTicketIdGenerator = ticketGrantingTicketUniqueTicketIdGenerator;
    }

    public void setTicketGrantingTicketExpirationPolicy(ExpirationPolicy ticketGrantingTicketExpirationPolicy) {
        this.ticketGrantingTicketExpirationPolicy = ticketGrantingTicketExpirationPolicy;
    }
}

