/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket;

import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.AbstractTicket;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ProxyGrantingTicketImpl;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.proxy.ProxyGrantingTicket;
import org.springframework.util.Assert;

@Entity
@Table(name="SERVICETICKET")
@DiscriminatorColumn(name="TYPE")
@DiscriminatorValue(value="ST")
public class ServiceTicketImpl
extends AbstractTicket
implements ServiceTicket {
    private static final long serialVersionUID = -4223319704861765405L;
    @Lob
    @Column(name="SERVICE", nullable=false, length=0x7FFFFFFF)
    private Service service;
    @Column(name="FROM_NEW_LOGIN", nullable=false)
    private boolean fromNewLogin;
    @Column(name="TICKET_ALREADY_GRANTED", nullable=false)
    private Boolean grantedTicketAlready = Boolean.FALSE;

    public ServiceTicketImpl() {
    }

    public ServiceTicketImpl(String id, @NotNull TicketGrantingTicketImpl ticket, @NotNull Service service, boolean fromNewLogin, ExpirationPolicy policy) {
        super(id, ticket, policy);
        Assert.notNull((Object)service, (String)"service cannot be null");
        Assert.notNull((Object)ticket, (String)"ticket cannot be null");
        this.service = service;
        this.fromNewLogin = fromNewLogin;
    }

    public boolean isFromNewLogin() {
        return this.fromNewLogin;
    }

    public Service getService() {
        return this.service;
    }

    public boolean isValidFor(Service serviceToValidate) {
        this.updateState();
        return serviceToValidate.matches(this.service);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof ServiceTicket)) {
            return false;
        }
        Ticket ticket = (Ticket)object;
        return new EqualsBuilder().append((Object)ticket.getId(), (Object)this.getId()).isEquals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyGrantingTicket grantProxyGrantingTicket(String id, Authentication authentication, ExpirationPolicy expirationPolicy) {
        ServiceTicketImpl serviceTicketImpl = this;
        synchronized (serviceTicketImpl) {
            if (this.grantedTicketAlready.booleanValue()) {
                throw new IllegalStateException("PGT already generated for this ST. Cannot grant more than one TGT for ST");
            }
            this.grantedTicketAlready = Boolean.TRUE;
        }
        ProxyGrantingTicketImpl pgt = new ProxyGrantingTicketImpl(id, this.service, this.getGrantingTicket(), authentication, expirationPolicy);
        this.getGrantingTicket().getProxyGrantingTickets().add(pgt);
        return pgt;
    }

    public Authentication getAuthentication() {
        return null;
    }
}

