/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.proxy.support;

import java.net.URL;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HttpBasedServiceCredential;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.UniqueTicketIdGenerator;
import org.jasig.cas.ticket.proxy.ProxyHandler;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.jasig.cas.util.http.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="proxy20Handler")
public final class Cas20ProxyHandler
implements ProxyHandler {
    private static final int BUFFER_LENGTH_ADDITIONAL_CHARGE = 15;
    private static final String PARAMETER_PROXY_GRANTING_TICKET_IOU = "pgtIou";
    private static final String PARAMETER_PROXY_GRANTING_TICKET_ID = "pgtId";
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    @Autowired
    @Qualifier(value="proxy20TicketUniqueIdGenerator")
    private UniqueTicketIdGenerator uniqueTicketIdGenerator = new DefaultUniqueTicketIdGenerator();
    @NotNull
    @Autowired
    @Qualifier(value="supportsTrustStoreSslSocketFactoryHttpClient")
    private HttpClient httpClient;

    public String handle(Credential credential, TicketGrantingTicket proxyGrantingTicketId) {
        HttpBasedServiceCredential serviceCredentials = (HttpBasedServiceCredential)credential;
        String proxyIou = this.uniqueTicketIdGenerator.getNewTicketId("PGTIOU");
        URL callbackUrl = serviceCredentials.getCallbackUrl();
        String serviceCredentialsAsString = callbackUrl.toExternalForm();
        int bufferLength = serviceCredentialsAsString.length() + proxyIou.length() + proxyGrantingTicketId.getId().length() + 15;
        StringBuilder stringBuffer = new StringBuilder(bufferLength);
        stringBuffer.append(serviceCredentialsAsString);
        if (callbackUrl.getQuery() != null) {
            stringBuffer.append('&');
        } else {
            stringBuffer.append('?');
        }
        stringBuffer.append(PARAMETER_PROXY_GRANTING_TICKET_IOU);
        stringBuffer.append('=');
        stringBuffer.append(proxyIou);
        stringBuffer.append('&');
        stringBuffer.append(PARAMETER_PROXY_GRANTING_TICKET_ID);
        stringBuffer.append('=');
        stringBuffer.append(proxyGrantingTicketId);
        if (this.httpClient.isValidEndPoint(stringBuffer.toString())) {
            this.logger.debug("Sent ProxyIou of {} for service: {}", (Object)proxyIou, (Object)serviceCredentials);
            return proxyIou;
        }
        this.logger.debug("Failed to send ProxyIou of {} for service: {}", (Object)proxyIou, (Object)serviceCredentials);
        return null;
    }

    public void setUniqueTicketIdGenerator(UniqueTicketIdGenerator uniqueTicketIdGenerator) {
        this.uniqueTicketIdGenerator = uniqueTicketIdGenerator;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public boolean canHandle(Credential credential) {
        return true;
    }
}

